/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityAttachment;

public class WarpRendering {
    public static int getWarpColor(MirthdewEncoreEntityAttachment entityAttachment, boolean translucent, float partialTicks) {
        float startProgress = entityAttachment.getWarpStartProgress(partialTicks);
        float endProgress = entityAttachment.getWarpEndProgress(partialTicks);
        float a = (translucent ? 0.14901961f : 1.0f) * (1.0f - startProgress * 0.6f - endProgress * 0.4f);
        float r = 1.0f - startProgress * 0.6f + endProgress * 0.3f;
        float g = 1.0f - startProgress * 0.7f + endProgress * 0.3f;
        float b = 1.0f - endProgress * 0.4f;
        return FastColor.ARGB32.colorFromFloat((float)a, (float)r, (float)g, (float)b);
    }

    public static int getLightColor(MirthdewEncoreEntityAttachment entityAttachment, int packedLight, float partialTicks) {
        int blockLight = LightTexture.block((int)packedLight);
        int skyLight = LightTexture.sky((int)packedLight);
        blockLight = Math.min(Mth.floor((float)((float)blockLight + entityAttachment.getWarpStartProgress(partialTicks) * 15.0f)), 15);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }

    public static void renderWarpScreenEffect(GuiGraphics guiGraphics, LocalPlayer player, float partialTicks) {
        MirthdewEncoreEntityAttachment meea = MirthdewEncoreEntityAttachment.fromEntity((Entity)player);
        float startProgress = meea.getWarpStartProgress(partialTicks);
        float endProgress = meea.getWarpEndProgress(partialTicks);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.setColor(0.2f, 0.4f, 0.4f, 1.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MirthdewEncore.id("textures/environment/dreamtwirl_nova_swirl.png"));
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)guiGraphics.guiHeight() / 2.0f, 0.0f);
        float scale = (float)Math.max(guiGraphics.guiWidth(), guiGraphics.guiHeight()) / 2.0f;
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int SWIRLS = 15;
        for (int i = 0; i < SWIRLS; ++i) {
            float p = (float)i / (float)SWIRLS;
            guiGraphics.pose().pushPose();
            float size = 0.1f * ((float)(1 + i) + 0.1f * (float)i * (float)i) * (2.5f - startProgress - endProgress);
            guiGraphics.pose().scale(size, size, 1.0f);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(360.0f * (((float)meea.getWarpTicks() + partialTicks) / 80.0f) * (1.0f + p * 3.0f) + (float)(i * 413)));
            Matrix4f matrix4f = guiGraphics.pose().last().pose();
            float a = startProgress * 0.7f + endProgress * 0.3f;
            float r = (1.0f - p) * 0.5f * a;
            float g = p * a;
            float b = a;
            int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b);
            bufferbuilder.addVertex(matrix4f, -1.0f, -1.0f, -90.0f).setUv(0.0f, 0.0f).setColor(color);
            bufferbuilder.addVertex(matrix4f, -1.0f, 1.0f, -90.0f).setUv(0.0f, 1.0f).setColor(color);
            bufferbuilder.addVertex(matrix4f, 1.0f, 1.0f, -90.0f).setUv(1.0f, 1.0f).setColor(color);
            bufferbuilder.addVertex(matrix4f, 1.0f, -1.0f, -90.0f).setUv(1.0f, 0.0f).setColor(color);
            guiGraphics.pose().popPose();
        }
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        guiGraphics.pose().popPose();
        RenderSystem.defaultBlendFunc();
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }
}

