/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.world;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import phanastrae.mirthdew_encore.client.render.shader.MirthdewEncoreShaders;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.util.RegionPos;
import phanastrae.mirthdew_encore.world.dimension.MirthdewEncoreDimensions;

public class DreamtwirlBorderRenderer {
    @Nullable
    private static RenderTarget framebuffer;
    private static int fbWidth;
    private static int fbHeight;

    public static void render(Matrix4f positionMatrix, ClientLevel clientLevel, Camera camera) {
        if (clientLevel.dimensionTypeRegistration().is(MirthdewEncoreDimensions.DREAMTWIRL_DIM_TYPE)) {
            RegionPos regionPos = DreamtwirlBorderRenderer.getRegionPosFromEntityOrElseCamera(camera);
            int minBuildHeight = clientLevel.getMinBuildHeight();
            int maxBuildHeight = clientLevel.getMaxBuildHeight();
            int centerX = regionPos.getCenterX();
            int centerY = (minBuildHeight + maxBuildHeight) / 2;
            int centerZ = regionPos.getCenterZ();
            Vec3 camPos = camera.getPosition();
            float offsetX = (float)((double)centerX - camPos.x);
            float offsetY = (float)((double)centerY - camPos.y);
            float offsetZ = (float)((double)centerZ - camPos.z);
            DreamtwirlBorderRenderer.renderDreamtwirlBorder(positionMatrix, offsetX, offsetY, offsetZ);
        }
    }

    public static void renderDreamtwirlBorder(Matrix4f positionMatrix, float offsetX, float offsetY, float offsetZ) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        modelViewStack.mul((Matrix4fc)positionMatrix);
        modelViewStack.pushMatrix();
        modelViewStack.translate(offsetX, 0.0f, offsetZ);
        RenderSystem.applyModelViewMatrix();
        DreamtwirlBorderRenderer.renderOuterDepthBorder();
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        DreamtwirlBorderRenderer.copyScreenToFramebuffer();
        DreamtwirlBorderRenderer.renderInnerGlowyBorder(offsetX, offsetY, offsetZ);
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderOuterDepthBorder() {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.enableDepthTest();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        DreamtwirlBorderRenderer.drawBorderQuads(bufferBuilder, 256.0f, 1024.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.disableDepthTest();
    }

    public static void copyScreenToFramebuffer() {
        Minecraft client = Minecraft.getInstance();
        RenderTarget clientFramebuffer = client.getMainRenderTarget();
        int width = clientFramebuffer.viewWidth;
        int height = clientFramebuffer.viewHeight;
        if (framebuffer == null) {
            framebuffer = new TextureTarget(width, height, true, Minecraft.ON_OSX);
            fbWidth = width;
            fbHeight = height;
        } else if (width != fbWidth || height != fbHeight) {
            framebuffer.resize(width, height, Minecraft.ON_OSX);
            fbWidth = width;
            fbHeight = height;
        }
        framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        framebuffer.clear(Minecraft.ON_OSX);
        ShaderInstance shaderInstance = Objects.requireNonNull(client.gameRenderer.blitShader, "Blit shader not loaded");
        shaderInstance.setSampler("DiffuseSampler", (Object)clientFramebuffer.getColorTextureId());
        shaderInstance.apply();
        framebuffer.bindWrite(false);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        BufferBuilder bufferBuilder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLIT_SCREEN);
        bufferBuilder.addVertex(0.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 0.0f, 0.0f);
        bufferBuilder.addVertex(1.0f, 1.0f, 0.0f);
        bufferBuilder.addVertex(0.0f, 1.0f, 0.0f);
        BufferUploader.draw((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        clientFramebuffer.bindWrite(false);
        shaderInstance.clear();
    }

    public static void renderInnerGlowyBorder(float offsetX, float offsetY, float offsetZ) {
        RenderSystem.setShader(MirthdewEncoreShaders::getDreamtwirlBarrierShader);
        ShaderInstance shaderInstance = RenderSystem.getShader();
        if (shaderInstance == null || framebuffer == null) {
            return;
        }
        Uniform uniform = shaderInstance.CHUNK_OFFSET;
        RenderSystem.setShaderTexture((int)0, (int)framebuffer.getColorTextureId());
        if (uniform != null) {
            uniform.set(offsetX, offsetY, offsetZ);
        }
        RenderSystem.enableDepthTest();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        DreamtwirlBorderRenderer.drawBorderQuads(bufferBuilder, 240.03125f, 2048.0f);
        DreamtwirlBorderRenderer.drawBorderQuads(bufferBuilder, 240.03125f, -2048.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableDepthTest();
        if (uniform != null) {
            uniform.set(0.0f, 0.0f, 0.0f);
        }
        shaderInstance.clear();
    }

    public static void drawBorderQuads(BufferBuilder bufferBuilder, float horizontalRadius, float verticalRadius) {
        DreamtwirlBorderRenderer.drawBorderQuad(bufferBuilder, horizontalRadius, horizontalRadius, verticalRadius, -horizontalRadius, horizontalRadius);
        DreamtwirlBorderRenderer.drawBorderQuad(bufferBuilder, -horizontalRadius, -horizontalRadius, verticalRadius, horizontalRadius, -horizontalRadius);
        DreamtwirlBorderRenderer.drawBorderQuad(bufferBuilder, horizontalRadius, -horizontalRadius, verticalRadius, horizontalRadius, horizontalRadius);
        DreamtwirlBorderRenderer.drawBorderQuad(bufferBuilder, -horizontalRadius, horizontalRadius, verticalRadius, -horizontalRadius, -horizontalRadius);
    }

    public static void drawBorderQuad(BufferBuilder bufferBuilder, float x1, float x2, float y, float z1, float z2) {
        bufferBuilder.addVertex(x1, y, z1);
        bufferBuilder.addVertex(x1, -y, z1);
        bufferBuilder.addVertex(x2, -y, z2);
        bufferBuilder.addVertex(x2, y, z2);
    }

    public static void close() {
        if (framebuffer != null) {
            framebuffer.destroyBuffers();
            fbWidth = 0;
            fbHeight = 0;
        }
    }

    public static Vec3 getVec3dFromEntityOrElseDefault(Vec3 cameraPos) {
        Entity entity = Minecraft.getInstance().getCameraEntity();
        return entity == null ? cameraPos : entity.position();
    }

    public static RegionPos getRegionPosFromEntityOrElseVec3d(Vec3 cameraPos) {
        return RegionPos.fromVec3(DreamtwirlBorderRenderer.getVec3dFromEntityOrElseDefault(cameraPos));
    }

    public static RegionPos getRegionPosFromEntityOrElseCamera(Camera camera) {
        return DreamtwirlBorderRenderer.getRegionPosFromEntityOrElseVec3d(camera.getPosition());
    }

    public static void hideChunks(ObjectArrayList<SectionRenderDispatcher.RenderSection> builtChunks, Level world, int cameraChunkX, int cameraChunkZ) {
        if (world == null) {
            return;
        }
        DreamtwirlLevelAttachment DTWA = DreamtwirlLevelAttachment.fromLevel(world);
        if (DTWA == null) {
            return;
        }
        Vec3 cameraPos = new Vec3((double)(cameraChunkX << 4), 0.0, (double)(cameraChunkZ << 4));
        RegionPos cameraRegionPos = DreamtwirlBorderRenderer.getRegionPosFromEntityOrElseVec3d(cameraPos);
        builtChunks.removeIf(builtChunk -> {
            RegionPos chunkRegionPos = RegionPos.fromBlockPos(builtChunk.getOrigin());
            return !chunkRegionPos.equals(cameraRegionPos);
        });
    }

    public static boolean shouldHideEntity(Entity entity, double cameraX, double cameraY, double cameraZ) {
        RegionPos entityRegion;
        Level world = entity.level();
        if (world == null) {
            return false;
        }
        DreamtwirlLevelAttachment DTWA = DreamtwirlLevelAttachment.fromLevel(world);
        if (DTWA == null) {
            return false;
        }
        RegionPos currentRegion = DreamtwirlBorderRenderer.getRegionPosFromEntityOrElseVec3d(new Vec3(cameraX, cameraY, cameraZ));
        return !currentRegion.equals(entityRegion = RegionPos.fromEntity(entity));
    }
}

