/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import phanastrae.mirthdew_encore.MirthdewEncore;

public class DreamtwirlSkyRenderer {
    private static final ResourceLocation DREAMTWIRL_SKY_SPIRIT = MirthdewEncore.id("textures/environment/dreamtwirl_sky_spirit.png");
    private static final ResourceLocation DREAMTWIRL_NOVA = MirthdewEncore.id("textures/environment/dreamtwirl_nova.png");
    private static final ResourceLocation DREAMTWIRL_NOVA_SWIRL = MirthdewEncore.id("textures/environment/dreamtwirl_nova_swirl.png");
    private static final ResourceLocation DREAMTWIRL_LANDSCAPE_SKY_TWIRL = MirthdewEncore.id("textures/environment/dreamtwirl_landscape_sky_twirl.png");
    private static final ResourceLocation DREAMTWIRL_LANDSCAPE_CIRCUS = MirthdewEncore.id("textures/environment/dreamtwirl_landscape_circus.png");
    private static final ResourceLocation DREAMTWIRL_LANDSCAPE_BACK_MOUNTAINS = MirthdewEncore.id("textures/environment/dreamtwirl_landscape_back_mountains.png");
    private static final ResourceLocation DREAMTWIRL_LANDSCAPE_WATER = MirthdewEncore.id("textures/environment/dreamtwirl_landscape_water.png");
    private static final ResourceLocation END_SKY = ResourceLocation.withDefaultNamespace((String)"textures/environment/end_sky.png");
    private static final int DREAMTWIRL_SKY_SPIRT_COUNT = 413;
    protected final SkySpiritData[] skySpiritDatas = new SkySpiritData[413];
    @Nullable
    private VertexBuffer starsBuffer;
    @Nullable
    private VertexBuffer lightSkyBuffer;
    @Nullable
    private VertexBuffer cylinderBuffer;

    public DreamtwirlSkyRenderer() {
        RandomSource random = RandomSource.create();
        random.setSeed(612L);
        for (int i = 0; i < 413; ++i) {
            this.skySpiritDatas[i] = SkySpiritData.create((float)i / 413.0f, random);
        }
    }

    public void close() {
        this.closeIfNotNull(this.starsBuffer);
        this.closeIfNotNull(this.lightSkyBuffer);
        this.closeIfNotNull(this.cylinderBuffer);
    }

    private void closeIfNotNull(VertexBuffer vertexBuffer) {
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
    }

    private void createStars() {
        this.closeIfNotNull(this.starsBuffer);
        this.starsBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starsBuffer.bind();
        this.starsBuffer.upload(this.createStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private void createLightSky() {
        this.closeIfNotNull(this.lightSkyBuffer);
        this.lightSkyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.lightSkyBuffer.bind();
        this.lightSkyBuffer.upload(DreamtwirlSkyRenderer.createLightSky(Tesselator.getInstance(), 16.0f));
        VertexBuffer.unbind();
    }

    private void createCylinder() {
        this.closeIfNotNull(this.cylinderBuffer);
        this.cylinderBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.cylinderBuffer.bind();
        this.cylinderBuffer.upload(DreamtwirlSkyRenderer.createCylinder(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private MeshData createStars(Tesselator tessellator) {
        RandomSource random = RandomSource.create((long)1025L);
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int STAR_COUNT = 6120;
        for (int j = 0; j < STAR_COUNT; ++j) {
            float z;
            float y;
            float x = random.nextFloat() * 2.0f - 1.0f;
            float m = Mth.lengthSquared((float)x, (float)(y = random.nextFloat() * 2.0f - 1.0f), (float)(z = random.nextFloat() * 2.0f - 1.0f));
            if (m <= 0.010000001f || m >= 1.0f) continue;
            Vector3f vector3f = new Vector3f(x, y, z).normalize(100.0f);
            float zAngle = (float)(random.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf quaternionf = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)vector3f).rotateZ(zAngle);
            float phase = random.nextFloat();
            float red = 0.75f + 0.25f * (float)Math.sin((float)Math.PI * 2 * phase);
            float green = 0.85f + 0.15f * (float)Math.sin((float)Math.PI * 2 * (phase + 0.33333334f));
            float blue = 0.95f + 0.05f * (float)Math.sin((float)Math.PI * 2 * (phase - 0.33333334f));
            float l = 0.15f + random.nextFloat() * 0.1f;
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
            bufferBuilder.addVertex(vector3f.add((Vector3fc)new Vector3f(-l, -l, 0.0f).rotate((Quaternionfc)quaternionf))).setColor(red, green, blue, 1.0f);
        }
        return bufferBuilder.buildOrThrow();
    }

    private static MeshData createLightSky(Tesselator tessellator, float f) {
        float g = Math.signum(f) * 512.0f;
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        bufferBuilder.addVertex(0.0f, f, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.addVertex(g * Mth.cos((float)((float)i * ((float)Math.PI / 180))), f, 512.0f * Mth.sin((float)((float)i * ((float)Math.PI / 180))));
        }
        return bufferBuilder.buildOrThrow();
    }

    private static MeshData createCylinder(Tesselator tessellator) {
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float d = 100.0f;
        float yMax = d * (float)Math.PI * 0.5f;
        float yMin = -yMax;
        for (int i = 0; i < 128; ++i) {
            float p0 = (float)i / 128.0f;
            float p1 = (float)(i + 1) / 128.0f;
            float s0 = d * Mth.sin((float)(p0 * ((float)Math.PI * 2)));
            float c0 = d * Mth.cos((float)(p0 * ((float)Math.PI * 2)));
            float s1 = d * Mth.sin((float)(p1 * ((float)Math.PI * 2)));
            float c1 = d * Mth.cos((float)(p1 * ((float)Math.PI * 2)));
            bufferBuilder.addVertex(c0, yMax, s0).setUv(p0, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
            bufferBuilder.addVertex(c0, yMin, s0).setUv(p0, 1.0f).setColor(0.1f, 0.2f, 0.3f, 1.0f);
            bufferBuilder.addVertex(c1, yMin, s1).setUv(p1, 1.0f).setColor(0.1f, 0.2f, 0.3f, 1.0f);
            bufferBuilder.addVertex(c1, yMax, s1).setUv(p1, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return bufferBuilder.buildOrThrow();
    }

    public void renderSky(ClientLevel clientWorld, PoseStack matrices, Matrix4f projectionMatrix, float tickDelta, Camera camera, Runnable fogCallback) {
        int i;
        if (this.starsBuffer == null) {
            this.createStars();
        }
        if (this.lightSkyBuffer == null) {
            this.createLightSky();
        }
        if (this.cylinderBuffer == null) {
            this.createCylinder();
        }
        Tesselator tessellator = Tesselator.getInstance();
        float time = ((float)(clientWorld.getGameTime() % 24000L) + tickDelta) / 24000.0f;
        FogRenderer.levelFogColor();
        matrices.pushPose();
        matrices.scale(0.25f, 0.25f, 0.25f);
        matrices.mulPose(Axis.YN.rotationDegrees(20.0f));
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(5.0f * Mth.sin((float)((float)Math.PI * 2 * time * 20.0f))));
        matrices.translate(0.0f, 1.0f * Mth.sin((float)((float)Math.PI * 2 * time * 40.0f)), 0.0f);
        matrices.mulPose(Axis.ZN.rotationDegrees(25.0f));
        RenderSystem.depthMask((boolean)false);
        FogRenderer.setupNoFog();
        FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)192.0f, (boolean)false, (float)tickDelta);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * 2.0f));
        this.lightSkyBuffer.bind();
        ShaderInstance shaderProgram = RenderSystem.getShader();
        matrices.translate(0.0f, 80.0f, 0.0f);
        RenderSystem.setShaderColor((float)0.1f, (float)0.25f, (float)0.25f, (float)1.0f);
        this.lightSkyBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, shaderProgram);
        VertexBuffer.unbind();
        matrices.popPose();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        FogRenderer.setupNoFog();
        RenderSystem.setShaderColor((float)0.7f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * -3.0f));
        this.starsBuffer.bind();
        this.starsBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
        VertexBuffer.unbind();
        matrices.popPose();
        fogCallback.run();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)0.157f, (float)0.157f, (float)0.157f, (float)1.0f);
        matrices.pushPose();
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * -60.0f));
        Matrix4f matrix4f = matrices.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_SKY);
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float w = 10.0f;
        bufferBuilder.addVertex(matrix4f, w, 100.0f, -w).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, w, 100.0f, w).setUv(0.0f, 2.0f);
        bufferBuilder.addVertex(matrix4f, -w, 100.0f, w).setUv(2.0f, 2.0f);
        bufferBuilder.addVertex(matrix4f, -w, 100.0f, -w).setUv(2.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        matrices.popPose();
        RenderSystem.setShaderColor((float)0.3f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * 3.0f));
        matrix4f = matrices.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_NOVA);
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float k = 15.0f;
        bufferBuilder.addVertex(matrix4f, -k, 100.0f, -k).setUv(0.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, k, 100.0f, -k).setUv(1.0f, 0.0f);
        bufferBuilder.addVertex(matrix4f, k, 100.0f, k).setUv(1.0f, 1.0f);
        bufferBuilder.addVertex(matrix4f, -k, 100.0f, k).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.2f, (float)0.4f, (float)0.4f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_NOVA_SWIRL);
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * 20.0f));
        int SWIRLS = 15;
        for (i = 0; i < SWIRLS; ++i) {
            matrices.mulPose(Axis.YP.rotationDegrees(360.0f * time * -3.0f + (float)(i * 413)));
            matrix4f = matrices.last().pose();
            float p = (float)i / (float)SWIRLS;
            float r = (1.0f - p) * 0.5f;
            float g = p;
            float b = 1.0f;
            int color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b);
            float m = 8.0f + 3.0f * (float)i;
            bufferBuilder.addVertex(matrix4f, -m, 100.0f, -m).setUv(0.0f, 0.0f).setColor(color);
            bufferBuilder.addVertex(matrix4f, m, 100.0f, -m).setUv(1.0f, 0.0f).setColor(color);
            bufferBuilder.addVertex(matrix4f, m, 100.0f, m).setUv(1.0f, 1.0f).setColor(color);
            bufferBuilder.addVertex(matrix4f, -m, 100.0f, m).setUv(0.0f, 1.0f).setColor(color);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        matrices.popPose();
        RenderSystem.defaultBlendFunc();
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_LANDSCAPE_BACK_MOUNTAINS);
        for (i = 1; i <= 4; ++i) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees((float)(4 + 2 * i) * Mth.sin((float)((float)Math.PI * 2 * time * 20.0f + 0.4f * (float)i))));
            matrices.translate(0.0f, (float)(-(10 + i * 2)) + (1.0f + (float)i * 0.5f) * Mth.sin((float)((float)Math.PI * 2 * time * 40.0f + 0.4f * (float)i)), 0.0f);
            RenderSystem.setShaderColor((float)(0.03f * (float)i), (float)(0.08f * (float)i), (float)(0.08f * (float)i), (float)((float)i / 4.0f));
            this.cylinderBuffer.bind();
            this.cylinderBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionTexColorShader());
            VertexBuffer.unbind();
            matrices.popPose();
        }
        matrices.popPose();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.ZN.rotationDegrees(-10.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_LANDSCAPE_SKY_TWIRL);
        for (i = 1; i <= 7; ++i) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees((float)(12 + 5 * i) * Mth.sin((float)((float)Math.PI * 2 * time * 10.0f * (float)(8 - i) + 0.4f * (float)i))));
            matrices.translate(0.0f, (float)(30 - 15 * i) + (2.0f + (float)i * 3.0f) * Mth.sin((float)((float)Math.PI * 2 * time * 40.0f + 0.4f * (float)i)), 0.0f);
            RenderSystem.setShaderColor((float)(1.0f - 0.12f * (float)i), (float)(0.7f - 0.02f * (float)i), (float)(0.9f - 0.05f * (float)i), (float)(0.2f + (float)i * 0.1f));
            this.cylinderBuffer.bind();
            this.cylinderBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionTexColorShader());
            VertexBuffer.unbind();
            matrices.popPose();
        }
        matrices.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_SKY_SPIRIT);
        matrices.pushPose();
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        this.renderSpirits(matrices, (VertexConsumer)bufferBuilder, time);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        matrices.popPose();
        matrices.popPose();
        RenderSystem.defaultBlendFunc();
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_LANDSCAPE_CIRCUS);
        for (i = 1; i <= 6; ++i) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees((float)(8 + 2 * i) * Mth.sin((float)((float)Math.PI * 2 * time * 20.0f + 0.2f * (float)(i + 4)))));
            matrices.translate(0.0f, (float)(2 + i) * Mth.sin((float)((float)Math.PI * 2 * time * 40.0f + 0.2f * (float)(i + 4))), 0.0f);
            RenderSystem.setShaderColor((float)(0.1f + 0.03f * (float)i), (float)(0.2f + 0.08f * (float)i), (float)(0.2f + 0.08f * (float)i), (float)((float)(7 - i) / 8.0f));
            this.cylinderBuffer.bind();
            this.cylinderBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionTexColorShader());
            VertexBuffer.unbind();
            matrices.popPose();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.ZN.rotationDegrees(15.0f));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_LANDSCAPE_SKY_TWIRL);
        for (i = 1; i <= 3; ++i) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees((float)(12 + 5 * i) * Mth.sin((float)((float)Math.PI * 2 * time * 5.0f * (float)(8 - i) + 0.6f * (float)i))));
            matrices.translate(0.0f, (float)(-40 - 18 * i) + (2.0f + (float)i * 3.0f) * Mth.sin((float)((float)Math.PI * 2 * time * 10.0f + 0.4f * (float)i)), 0.0f);
            RenderSystem.setShaderColor((float)(0.1f + 0.2f * (float)i), (float)(0.8f - 0.2f * (float)i), (float)(0.7f - 0.1f * (float)i), (float)(0.05f + (float)i * 0.1f));
            this.cylinderBuffer.bind();
            this.cylinderBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionTexColorShader());
            VertexBuffer.unbind();
            matrices.popPose();
        }
        matrices.popPose();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        FogRenderer.setupNoFog();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        float j = 100.0f;
        matrix4f = matrices.last().pose();
        bufferBuilder.addVertex(matrix4f, j, -100.0f, j);
        bufferBuilder.addVertex(matrix4f, j, -100.0f, -j);
        bufferBuilder.addVertex(matrix4f, -j, -100.0f, -j);
        bufferBuilder.addVertex(matrix4f, -j, -100.0f, j);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        fogCallback.run();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_LANDSCAPE_WATER);
        for (int i2 = 1; i2 <= 6; ++i2) {
            matrices.pushPose();
            matrices.mulPose(Axis.YP.rotationDegrees((float)(10 + 3 * i2) * Mth.sin((float)((float)Math.PI * 2 * time * 20.0f + 0.5f * (float)(i2 + 6)))));
            matrices.translate(0.0f, (float)(3 + i2) * Mth.sin((float)((float)Math.PI * 2 * time * 40.0f + 0.5f * (float)(i2 + 6))), 0.0f);
            RenderSystem.setShaderColor((float)(0.04f + 0.04f * (float)i2), (float)(0.24f + 0.09f * (float)i2), (float)(0.24f + 0.09f * (float)i2), (float)((float)(7 - i2) / 8.0f));
            this.cylinderBuffer.bind();
            this.cylinderBuffer.drawWithShader(matrices.last().pose(), projectionMatrix, GameRenderer.getPositionTexColorShader());
            VertexBuffer.unbind();
            matrices.popPose();
        }
        matrices.popPose();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)0.3f, (float)0.2f, (float)0.4f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DREAMTWIRL_SKY_SPIRIT);
        matrices.pushPose();
        bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        this.renderSpirits(matrices, (VertexConsumer)bufferBuilder, time);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        matrices.popPose();
        matrices.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderSpirits(PoseStack matrices, VertexConsumer vertexConsumer, float time) {
        for (SkySpiritData data : this.skySpiritDatas) {
            matrices.pushPose();
            float timeOffset = data.timeOffset;
            float angleOffset = data.angleOffset;
            float localTime = time + timeOffset;
            int spiritSpeed = 1 + Mth.floor((float)(6.0f * (angleOffset % 1.0f)));
            float height = localTime * 7.0f * (float)spiritSpeed % 1.0f * 2.0f - 1.0f;
            float distFromMiddle = Mth.abs((float)height);
            float distFromEndpoints = 1.0f - distFromMiddle;
            float distFromGate = 1.0f - height;
            matrices.mulPose(Axis.YP.rotationDegrees(angleOffset + height * 100.0f * (timeOffset - 0.5f)));
            matrices.mulPose(Axis.XP.rotationDegrees(40.0f * height));
            float sin = Mth.sin((float)((float)Math.PI * 2 * localTime * 65.0f));
            matrices.translate(0.1 * (double)sin, (double)(height * 48.0f), (double)(-64.0f + 8.0f * data.depth) * ((double)distFromGate * 0.5 + 0.8));
            matrices.scale(2.0f, 2.0f, 2.0f);
            Matrix4f matrix4f = matrices.last().pose();
            float alpha = 0.3f * distFromEndpoints;
            DreamtwirlSkyRenderer.drawSpirit(vertexConsumer, matrix4f, localTime, distFromMiddle * alpha * data.red, alpha * data.green, alpha * data.blue);
            matrices.popPose();
        }
    }

    private static void drawSpirit(VertexConsumer vertexConsumer, Matrix4f matrix4f, float time, float red, float green, float blue) {
        int r = 0xFF & (int)(red * 255.0f);
        int g = 0xFF & (int)(green * 255.0f);
        int b = 0xFF & (int)(blue * 255.0f);
        int color = 0xFF000000 | r << 16 | g << 8 | b;
        float wiggle1 = 0.5f * Mth.sin((float)((float)Math.PI * 2 * time * 400.0f));
        float wiggle2 = 0.5f * Mth.sin((float)((float)Math.PI * 2 * time * 400.0f + 0.4f));
        float wiggle3 = 0.5f * Mth.sin((float)((float)Math.PI * 2 * time * 400.0f + 0.8f));
        float wiggle4 = 0.5f * Mth.sin((float)((float)Math.PI * 2 * time * 400.0f + 1.2f));
        float[] wiggles = new float[]{wiggle1, wiggle2, wiggle3, wiggle4};
        int animationFrame = (int)(time * 12000.0f) % 4;
        float minU = (float)animationFrame / 4.0f;
        float maxU = (float)(animationFrame + 1) / 4.0f;
        int SEGMENTS = 3;
        for (int i = 0; i < SEGMENTS; ++i) {
            float topWiggle = wiggles[i];
            float bottomWiggle = wiggles[i + 1];
            float topV = (float)i / (float)SEGMENTS;
            float bottomV = (float)(i + 1) / (float)SEGMENTS;
            float topY = 4.0f * (1.0f - 2.0f * topV);
            float bottomY = 4.0f * (1.0f - 2.0f * bottomV);
            vertexConsumer.addVertex(matrix4f, topWiggle - 1.0f, topY, 0.0f).setUv(minU, topV).setColor(color);
            vertexConsumer.addVertex(matrix4f, bottomWiggle - 1.0f, bottomY, 0.0f).setUv(minU, bottomV).setColor(color);
            vertexConsumer.addVertex(matrix4f, bottomWiggle + 1.0f, bottomY, 0.0f).setUv(maxU, bottomV).setColor(color);
            vertexConsumer.addVertex(matrix4f, topWiggle + 1.0f, topY, 0.0f).setUv(maxU, topV).setColor(color);
        }
    }

    public static class SkySpiritData {
        public final float depth;
        public final float timeOffset;
        public final float angleOffset;
        public final float red;
        public final float green;
        public final float blue;

        public SkySpiritData(float depth, float timeOffset, float angleOffset, float red, float green, float blue) {
            this.depth = depth;
            this.timeOffset = timeOffset;
            this.angleOffset = angleOffset;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public static SkySpiritData create(float depth, RandomSource random) {
            float timeOffset = random.nextFloat();
            float angleOffset = random.nextFloat() * 360.0f;
            float phase = random.nextFloat();
            float red = 0.9f + 0.1f * (float)Math.sin((float)Math.PI * 2 * phase);
            float green = 0.9f + 0.1f * (float)Math.sin((float)Math.PI * 2 * (phase + 0.33333334f));
            float blue = 0.9f + 0.1f * (float)Math.sin((float)Math.PI * 2 * (phase - 0.33333334f));
            return new SkySpiritData(depth, timeOffset, angleOffset, red, green, blue);
        }
    }
}

