/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.client.render.world;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import phanastrae.mirthdew_encore.client.render.world.DreamtwirlSkyRenderer;

public class MirthdewEncoreDimensionEffects {
    private static final MirthdewEncoreDimensionEffects INSTANCE = new MirthdewEncoreDimensionEffects();
    public DreamtwirlSkyRenderer dreamtwirlSkyRenderer;

    public static MirthdewEncoreDimensionEffects getInstance() {
        return INSTANCE;
    }

    private MirthdewEncoreDimensionEffects() {
    }

    public void close() {
        this.dreamtwirlSkyRenderer.close();
    }

    public void init() {
        this.dreamtwirlSkyRenderer = new DreamtwirlSkyRenderer();
    }

    public static DimensionSpecialEffects getDreamtwirlDimensionEffects() {
        return new DimensionSpecialEffects(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, false, false){

            public Vec3 getBrightnessDependentFogColor(Vec3 color, float sunHeight) {
                return color;
            }

            public boolean isFoggyAt(int camX, int camY) {
                return false;
            }

            public float[] getSunriseColor(float skyAngle, float tickDelta) {
                return null;
            }
        };
    }

    public static void renderSky(Matrix4f positionMatrix, DeltaTracker deltaTracker, GameRenderer gameRenderer, Camera camera, ClientLevel level, Matrix4f projectionMatrix) {
        PoseStack matrices = new PoseStack();
        matrices.mulPose(positionMatrix);
        float tickDelta = deltaTracker.getGameTimeDeltaPartialTick(false);
        Minecraft client = gameRenderer.getMinecraft();
        boolean useThickFog = client.gui.getBossOverlay().shouldCreateWorldFog();
        Runnable fogCallback = () -> FogRenderer.setupFog((Camera)camera, (FogRenderer.FogMode)FogRenderer.FogMode.FOG_SKY, (float)gameRenderer.getRenderDistance(), (boolean)useThickFog, (float)tickDelta);
        MirthdewEncoreDimensionEffects.INSTANCE.dreamtwirlSkyRenderer.renderSky(level, matrices, projectionMatrix, tickDelta, camera, fogCallback);
    }
}

