/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.component.type;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.TooltipProvider;
import phanastrae.mirthdew_encore.mixin.FoodPropertiesPossibleEffectAccessor;

public record FoodWhenFullProperties(List<FoodProperties.PossibleEffect> effects, boolean showInTooltip) implements TooltipProvider
{
    public static final Codec<FoodWhenFullProperties> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FoodProperties.PossibleEffect.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodWhenFullProperties::effects), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)Boolean.TRUE).forGetter(FoodWhenFullProperties::showInTooltip)).apply((Applicative)instance, FoodWhenFullProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodWhenFullProperties> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)FoodProperties.PossibleEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), FoodWhenFullProperties::effects, (StreamCodec)ByteBufCodecs.BOOL, FoodWhenFullProperties::showInTooltip, FoodWhenFullProperties::new);

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        if (this.showInTooltip) {
            tooltip.accept((Component)Component.translatable((String)"item.modifiers.mirthdew_encore.food_when_full").withStyle(ChatFormatting.GRAY));
            for (FoodProperties.PossibleEffect effect : this.effects) {
                if ((double)effect.probability() != 1.0) continue;
                List<MobEffectInstance> list = List.of(effect.effect());
                PotionContents.addPotionTooltip(list, tooltip, (float)1.0f, (float)context.tickRate());
            }
            for (FoodProperties.PossibleEffect effect : this.effects) {
                if ((double)effect.probability() == 1.0) continue;
                float probability = effect.probability();
                int percentage = Mth.floor((float)(probability * 100.0f));
                tooltip.accept((Component)Component.translatable((String)"item.modifiers.mirthdew_encore.percentage_chance", (Object[])new Object[]{percentage}).withStyle(ChatFormatting.AQUA));
                List<MobEffectInstance> list = List.of(effect.effect());
                PotionContents.addPotionTooltip(list, tooltip, (float)1.0f, (float)context.tickRate());
            }
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<FoodProperties.PossibleEffect> effects = ImmutableList.builder();
        private boolean showInTooltip = true;

        public Builder effect(MobEffectInstance effect, float probability) {
            this.effects.add((Object)FoodPropertiesPossibleEffectAccessor.invokeInit(effect, probability));
            return this;
        }

        public Builder showInTooltip(boolean showInTooltip) {
            this.showInTooltip = showInTooltip;
            return this;
        }

        public FoodWhenFullProperties build() {
            return new FoodWhenFullProperties((List<FoodProperties.PossibleEffect>)this.effects.build(), this.showInTooltip);
        }
    }
}

