/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.component.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;

public record LinkedAcheruneComponent(long regionId, long timestamp, ResourceLocation dimensionId, long acId, long acTimestamp) {
    public static final Codec<LinkedAcheruneComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("id").forGetter(LinkedAcheruneComponent::regionId), (App)Codec.LONG.fieldOf("timestamp").forGetter(LinkedAcheruneComponent::timestamp), (App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(LinkedAcheruneComponent::dimensionId), (App)Codec.LONG.fieldOf("ac_id").forGetter(LinkedAcheruneComponent::acId), (App)Codec.LONG.fieldOf("ac_timestamp").forGetter(LinkedAcheruneComponent::acTimestamp)).apply((Applicative)instance, LinkedAcheruneComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LinkedAcheruneComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, LinkedAcheruneComponent::regionId, (StreamCodec)ByteBufCodecs.VAR_LONG, LinkedAcheruneComponent::timestamp, (StreamCodec)ResourceLocation.STREAM_CODEC, LinkedAcheruneComponent::dimensionId, (StreamCodec)ByteBufCodecs.VAR_LONG, LinkedAcheruneComponent::acId, (StreamCodec)ByteBufCodecs.VAR_LONG, LinkedAcheruneComponent::acTimestamp, LinkedAcheruneComponent::new);

    public static LinkedAcheruneComponent fromAcheruneAndStage(DreamtwirlStage stage, Acherune acherune) {
        return new LinkedAcheruneComponent(stage.getId(), stage.getTimestamp(), stage.getLevel().dimension().location(), acherune.getId().id(), acherune.getId().timestamp());
    }

    @Nullable
    public Level getLevel(MinecraftServer server) {
        return server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.dimensionId));
    }

    @Nullable
    public DreamtwirlStage getStage(MinecraftServer server) {
        Level linkedLevel = this.getLevel(server);
        if (linkedLevel == null) {
            return null;
        }
        DreamtwirlStageManager dreamtwirlStageManager = DreamtwirlStageManager.getDreamtwirlStageManager(linkedLevel);
        if (dreamtwirlStageManager == null) {
            return null;
        }
        DreamtwirlStage stage = dreamtwirlStageManager.getDreamtwirlIfPresent(this.regionId);
        if (stage == null) {
            return null;
        }
        if (stage.getTimestamp() == this.timestamp) {
            return stage;
        }
        return null;
    }

    @Nullable
    public Acherune getAcherune(MinecraftServer server) {
        DreamtwirlStage stage = this.getStage(server);
        if (stage == null) {
            return null;
        }
        return stage.getStageAcherunes().getAcherune(this.getAcheruneId());
    }

    public Acherune.AcheruneId getAcheruneId() {
        return new Acherune.AcheruneId(this.acTimestamp, this.acId);
    }
}

