/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.component.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record LocationComponent(double x, double y, double z, ResourceLocation dimensionId) {
    public static final Codec<LocationComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(LocationComponent::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(LocationComponent::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(LocationComponent::z), (App)ResourceLocation.CODEC.fieldOf("dimension").forGetter(LocationComponent::dimensionId)).apply((Applicative)instance, LocationComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LocationComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, LocationComponent::x, (StreamCodec)ByteBufCodecs.DOUBLE, LocationComponent::y, (StreamCodec)ByteBufCodecs.DOUBLE, LocationComponent::z, (StreamCodec)ResourceLocation.STREAM_CODEC, LocationComponent::dimensionId, LocationComponent::new);

    public static LocationComponent fromPosAndLevel(Vec3 pos, Level level) {
        return new LocationComponent(pos.x, pos.y, pos.z, level.dimension().location());
    }

    public Vec3 getPos() {
        return new Vec3(this.x, this.y, this.z);
    }

    @Nullable
    public Level getLevel(MinecraftServer server) {
        return server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.dimensionId));
    }
}

