/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.component.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.card_spell.SpellCast;

public record SpellChargeComponent(long cooldownStart, int cooldownLength, int maxCasts, List<SpellCast> spellCasts, int storedRechargeDelayMs) {
    public static final Codec<SpellChargeComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("cooldownStart", (Object)0L).forGetter(SpellChargeComponent::cooldownStart), (App)Codec.INT.optionalFieldOf("cooldownLength", (Object)0).forGetter(SpellChargeComponent::cooldownLength), (App)Codec.INT.optionalFieldOf("max_casts", (Object)0).forGetter(SpellChargeComponent::maxCasts), (App)SpellCast.CODEC.listOf().optionalFieldOf("spell_casts", List.of()).forGetter(SpellChargeComponent::spellCasts), (App)Codec.INT.optionalFieldOf("stored_recharge_delay_ms", (Object)0).forGetter(SpellChargeComponent::storedRechargeDelayMs)).apply((Applicative)instance, SpellChargeComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SpellChargeComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SpellChargeComponent::cooldownStart, (StreamCodec)ByteBufCodecs.INT, SpellChargeComponent::cooldownLength, (StreamCodec)ByteBufCodecs.INT, SpellChargeComponent::maxCasts, (StreamCodec)SpellCast.PACKET_CODEC.apply(ByteBufCodecs.list()), SpellChargeComponent::spellCasts, (StreamCodec)ByteBufCodecs.INT, SpellChargeComponent::storedRechargeDelayMs, SpellChargeComponent::new);

    public boolean isEmpty() {
        return this.spellCasts.isEmpty();
    }

    public boolean isDisabled(long worldTime) {
        return this.cooldownLength > 0 && worldTime < this.cooldownStart + (long)this.cooldownLength;
    }

    public float getRemainingCooldown(long worldTime, float tickDelta) {
        if (this.cooldownLength <= 0) {
            return 0.0f;
        }
        int cooldownProgress = Math.clamp(worldTime - this.cooldownStart, 0, this.cooldownLength);
        float cooldownProgressRelative = ((float)cooldownProgress + tickDelta) / (float)this.cooldownLength;
        return Math.clamp(1.0f - cooldownProgressRelative, 0.0f, 1.0f);
    }

    public static class Builder {
        long cooldownStart;
        int cooldownLength;
        int maxCasts;
        final List<SpellCast> spellCasts;
        int storedRechargeDelayMs;

        public Builder(List<SpellCast> spellCastList) {
            this.cooldownStart = 0L;
            this.cooldownLength = 0;
            this.maxCasts = spellCastList.size();
            this.spellCasts = new ArrayList<SpellCast>(spellCastList);
            this.storedRechargeDelayMs = 0;
        }

        public Builder(SpellChargeComponent spellChargeComponent) {
            this.cooldownStart = spellChargeComponent.cooldownStart;
            this.cooldownLength = spellChargeComponent.cooldownLength;
            this.maxCasts = spellChargeComponent.maxCasts;
            this.spellCasts = new ArrayList<SpellCast>(spellChargeComponent.spellCasts);
            this.storedRechargeDelayMs = spellChargeComponent.storedRechargeDelayMs;
        }

        public void setCooldown(long start, int length) {
            this.cooldownStart = start;
            this.cooldownLength = length;
        }

        public void add(SpellCast spellCast) {
            this.spellCasts.add(spellCast);
        }

        public void addAll(List<SpellCast> spellCast) {
            this.spellCasts.addAll(spellCast);
        }

        public boolean isEmpty() {
            return this.spellCasts.isEmpty();
        }

        @Nullable
        public SpellCast removeFirst() {
            if (this.spellCasts.isEmpty()) {
                return null;
            }
            return this.spellCasts.removeFirst();
        }

        public void addRechargeDelay(int timeMs) {
            this.storedRechargeDelayMs += timeMs;
        }

        public int removeRechargeDelay() {
            int storedDelay = this.storedRechargeDelayMs;
            this.storedRechargeDelayMs = 0;
            return storedDelay;
        }

        public SpellChargeComponent build() {
            return new SpellChargeComponent(this.cooldownStart, this.cooldownLength, this.maxCasts, this.spellCasts, this.storedRechargeDelayMs);
        }
    }
}

