/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.data.worldgen.features;

import java.util.OptionalInt;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.CherryFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;

public class MirthdewEncoreTreeFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> DECIDRHEUM = MirthdewEncoreTreeFeatures.createKey("decidrheum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FANCY_DECIDRHEUM = MirthdewEncoreTreeFeatures.createKey("fancy_decidrheum");

    public static void bootstrapTreeFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holderGetter = context.lookup(Registries.BLOCK);
        FeatureUtils.register(context, DECIDRHEUM, (Feature)Feature.TREE, (FeatureConfiguration)MirthdewEncoreTreeFeatures.createDecidrheum().build());
        FeatureUtils.register(context, FANCY_DECIDRHEUM, (Feature)Feature.TREE, (FeatureConfiguration)MirthdewEncoreTreeFeatures.createFancyDecidrheum().build());
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block logBlock, Block leavesBlock, int baseHeight, int heightRandA, int heightRandB, int radius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)logBlock), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, heightRandA, heightRandB), (BlockStateProvider)BlockStateProvider.simple((Block)leavesBlock), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)radius), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createDecidrheum() {
        return MirthdewEncoreTreeFeatures.createStraightBlobTree(MirthdewEncoreBlocks.DECIDRHEUM_LOG, MirthdewEncoreBlocks.DECIDRHEUM_LEAVES, 4, 2, 0, 2).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)MirthdewEncoreBlocks.ONYXSCALE));
    }

    private static TreeConfiguration.TreeConfigurationBuilder createFancyDecidrheum() {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)MirthdewEncoreBlocks.DECIDRHEUM_LOG), (TrunkPlacer)new UpwardsBranchingTrunkPlacer(6, 7, 2, (IntProvider)UniformInt.of((int)1, (int)4), 0.4f, (IntProvider)UniformInt.of((int)1, (int)4), HolderSet.empty()), (BlockStateProvider)BlockStateProvider.simple((Block)MirthdewEncoreBlocks.DECIDRHEUM_LEAVES), (FoliagePlacer)new CherryFoliagePlacer((IntProvider)ConstantInt.of((int)3), (IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)4), 0.35f, 0.5f, 0.35f, 0.25f), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().dirt((BlockStateProvider)BlockStateProvider.simple((Block)MirthdewEncoreBlocks.ONYXSCALE));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)MirthdewEncore.id(name));
    }
}

