/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.play.DreamtwirlBorder;
import phanastrae.mirthdew_encore.duck.LevelDuckInterface;
import phanastrae.mirthdew_encore.util.RegionPos;

public class DreamtwirlLevelAttachment {
    public final Level level;
    @Nullable
    private DreamtwirlStageManager dreamtwirlStageManager;

    public DreamtwirlLevelAttachment(Level level) {
        this.level = level;
    }

    public void tick(boolean runsNormally) {
        Level level;
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tickServerLevel(serverLevel, runsNormally);
        }
    }

    private void tickServerLevel(ServerLevel level, boolean runsNormally) {
        if (this.dreamtwirlStageManager != null) {
            this.dreamtwirlStageManager.tick(runsNormally);
        }
    }

    @Nullable
    public DreamtwirlStageManager getDreamtwirlStageManager() {
        return this.dreamtwirlStageManager;
    }

    public void setDreamtwirlStageManager(ServerLevel level) {
        this.dreamtwirlStageManager = (DreamtwirlStageManager)level.getDataStorage().computeIfAbsent(DreamtwirlStageManager.getPersistentStateType(level), DreamtwirlStageManager.nameFor((Holder<DimensionType>)level.dimensionTypeRegistration()));
    }

    @Nullable
    public DreamtwirlBorder getDreamtwirlBorder(RegionPos regionPos) {
        if (this.level.isClientSide) {
            return new DreamtwirlBorder(regionPos);
        }
        DreamtwirlStageManager dsm = this.getDreamtwirlStageManager();
        if (dsm == null) {
            return null;
        }
        DreamtwirlStage stage = dsm.getDreamtwirlIfPresent(regionPos);
        if (stage == null) {
            return null;
        }
        return stage.getDreamtwirlBorder();
    }

    @Nullable
    public static DreamtwirlLevelAttachment fromLevel(Level level) {
        return ((LevelDuckInterface)level).mirthdew_encore$getDreamtwirlAttachment();
    }

    public static void findBorderCollision(@Nullable Entity entity, Level level, ImmutableList.Builder<VoxelShape> builder) {
        if (entity == null) {
            return;
        }
        if (entity.level() != level) {
            return;
        }
        DreamtwirlLevelAttachment DTLA = DreamtwirlLevelAttachment.fromLevel(level);
        if (DTLA == null) {
            return;
        }
        RegionPos regionPos = RegionPos.fromEntity(entity);
        DreamtwirlBorder border = DTLA.getDreamtwirlBorder(regionPos);
        if (border != null) {
            builder.add((Object)border.voxelShape);
        }
    }

    public static void tickLevel(Level level) {
        DreamtwirlLevelAttachment DTLA = DreamtwirlLevelAttachment.fromLevel(level);
        if (DTLA == null) {
            return;
        }
        DTLA.tick(level.tickRateManager().runsNormally());
    }

    public static boolean positionsAreInSeparateDreamtwirls(Level level, Vec3 pos1, Vec3 pos2) {
        RegionPos region2;
        DreamtwirlLevelAttachment DTLA = DreamtwirlLevelAttachment.fromLevel(level);
        if (DTLA == null) {
            return false;
        }
        RegionPos region1 = RegionPos.fromVec3(pos1);
        return !region1.equals(region2 = RegionPos.fromVec3(pos2));
    }

    public static boolean posInUnstableDreamtwirl(Level level, Vec3 pos) {
        DreamtwirlLevelAttachment DTLA = DreamtwirlLevelAttachment.fromLevel(level);
        if (DTLA == null) {
            return false;
        }
        DreamtwirlStageManager dsm = DTLA.getDreamtwirlStageManager();
        if (dsm == null) {
            return false;
        }
        RegionPos region = RegionPos.fromVec3(pos);
        DreamtwirlStage stage = dsm.getDreamtwirlIfPresent(region);
        return stage == null || stage.isDeletingSelf();
    }

    public static boolean positionsAreInSeparateOrUnstableDreamtwirls(Level level, Vec3 pos1, Vec3 pos2) {
        if (DreamtwirlLevelAttachment.posInUnstableDreamtwirl(level, pos1)) {
            return true;
        }
        if (DreamtwirlLevelAttachment.posInUnstableDreamtwirl(level, pos2)) {
            return true;
        }
        return DreamtwirlLevelAttachment.positionsAreInSeparateDreamtwirls(level, pos1, pos2);
    }
}

