/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.dreamtwirl.stage.BasicStageData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.util.RegionPos;
import phanastrae.mirthdew_encore.world.dimension.MirthdewEncoreDimensions;

public class DreamtwirlStageManager
extends SavedData {
    public static final String KEY_MIN_RX = "min_region_x";
    public static final String KEY_MIN_RZ = "min_region_z";
    public static final String KEY_MAX_RX = "max_region_x";
    public static final String KEY_MAX_RZ = "max_region_z";
    public static final int DEFAULT_MIN_REGION_BOUND = -58593;
    public static final int DEFAULT_MAX_REGION_BOUND = 58592;
    private static final int CACHE_SIZE = 4;
    private final Map<Long, BasicStageData> basicStageDatas = new Object2ObjectOpenHashMap();
    private final Map<Long, DreamtwirlStage> dreamtwirls = new Object2ObjectOpenHashMap();
    private final ServerLevel level;
    private final RandomSource random = RandomSource.create();
    private boolean hasCheckedForDeletingStages = false;
    private final Long[] lastId = new Long[4];
    private final DreamtwirlStage[] lastStage = new DreamtwirlStage[4];
    private int minRegionX = -58593;
    private int minRegionZ = -58593;
    private int maxRegionX = 58592;
    private int maxRegionZ = 58592;

    public DreamtwirlStageManager(ServerLevel level) {
        this.level = level;
    }

    public static SavedData.Factory<DreamtwirlStageManager> getPersistentStateType(ServerLevel level) {
        return new SavedData.Factory(() -> new DreamtwirlStageManager(level), (nbt, registryLookup) -> DreamtwirlStageManager.fromNbt(level, nbt), null);
    }

    public static String nameFor(Holder<DimensionType> dimensionTypeEntry) {
        return "mirthdew_encore_dreamtwirls";
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ListTag nbtList = new ListTag();
        for (BasicStageData bsd : this.basicStageDatas.values()) {
            CompoundTag nbtCompound = new CompoundTag();
            bsd.writeNbt(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.put("DreamtwirlStages", (Tag)nbtList);
        nbt.putInt(KEY_MIN_RX, this.minRegionX);
        nbt.putInt(KEY_MIN_RZ, this.minRegionZ);
        nbt.putInt(KEY_MAX_RX, this.maxRegionX);
        nbt.putInt(KEY_MAX_RZ, this.maxRegionZ);
        return nbt;
    }

    public static DreamtwirlStageManager fromNbt(ServerLevel level, CompoundTag nbt) {
        DreamtwirlStageManager dreamtwirlStageManager = new DreamtwirlStageManager(level);
        ListTag nbtList = nbt.getList("DreamtwirlStages", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            BasicStageData bsd = BasicStageData.fromNbt(nbtCompound);
            dreamtwirlStageManager.basicStageDatas.put(bsd.getId(), bsd);
        }
        if (nbt.contains(KEY_MIN_RX, 3)) {
            dreamtwirlStageManager.minRegionX = nbt.getInt(KEY_MIN_RX);
        }
        if (nbt.contains(KEY_MIN_RZ, 3)) {
            dreamtwirlStageManager.minRegionZ = nbt.getInt(KEY_MIN_RZ);
        }
        if (nbt.contains(KEY_MAX_RX, 3)) {
            dreamtwirlStageManager.maxRegionX = nbt.getInt(KEY_MAX_RX);
        }
        if (nbt.contains(KEY_MAX_RZ, 3)) {
            dreamtwirlStageManager.maxRegionZ = nbt.getInt(KEY_MAX_RZ);
        }
        return dreamtwirlStageManager;
    }

    @Nullable
    public DreamtwirlStage getDreamtwirlIfPresent(RegionPos regionPos) {
        return this.getDreamtwirlIfPresent(regionPos.id);
    }

    @Nullable
    public DreamtwirlStage getDreamtwirlIfPresent(long id) {
        DreamtwirlStage stage;
        for (int j = 0; j < 4; ++j) {
            DreamtwirlStage stage2;
            if (!Objects.equals(id, this.lastId[j]) || (stage2 = this.lastStage[j]) == null || stage2.isRemoved()) continue;
            return stage2;
        }
        if (this.dreamtwirls.containsKey(id)) {
            stage = this.dreamtwirls.get(id);
        } else if (this.basicStageDatas.containsKey(id)) {
            BasicStageData basicStageData = this.basicStageDatas.get(id);
            DreamtwirlStage dreamtwirlStage = this.getExistingSavedStageData(basicStageData);
            this.dreamtwirls.put(id, dreamtwirlStage);
            this.setDirty();
            stage = dreamtwirlStage;
        } else {
            stage = null;
        }
        if (stage != null) {
            this.storeInCache(id, stage);
        }
        return stage;
    }

    private void storeInCache(long id, DreamtwirlStage stage) {
        for (int i = 3; i > 0; --i) {
            this.lastId[i] = this.lastId[i - 1];
            this.lastStage[i] = this.lastStage[i - 1];
        }
        this.lastId[0] = id;
        this.lastStage[0] = stage;
    }

    private void clearCache() {
        Arrays.fill((Object[])this.lastId, null);
        Arrays.fill((Object[])this.lastStage, null);
    }

    @Nullable
    public BasicStageData getBasicStageDataIfPresent(long id) {
        return this.basicStageDatas.getOrDefault(id, null);
    }

    public void tick(boolean runsNormally) {
        if (!this.hasCheckedForDeletingStages) {
            for (BasicStageData bsd : this.basicStageDatas.values()) {
                if (!bsd.isDeletingSelf()) continue;
                this.getDreamtwirlIfPresent(bsd.getId());
            }
            this.hasCheckedForDeletingStages = true;
        }
        List<DreamtwirlStage> stages = this.dreamtwirls.values().stream().toList();
        for (DreamtwirlStage dreamtwirlStage : stages) {
            dreamtwirlStage.tick(this.level, runsNormally);
        }
    }

    public void forEach(BiConsumer<Long, BasicStageData> biConsumer) {
        this.basicStageDatas.forEach(biConsumer);
    }

    public Map<Long, BasicStageData> getBasicStageDatas() {
        return this.basicStageDatas;
    }

    public int getDreamtwirlStageCount() {
        return this.basicStageDatas.size();
    }

    public int getDreamtwirlLoadedStagesCount() {
        return this.dreamtwirls.size();
    }

    public Optional<DreamtwirlStage> createNewStage() {
        Optional<RegionPos> regionPosOptional = this.findUnusedRegionPos();
        if (regionPosOptional.isPresent()) {
            DreamtwirlStage stage = this.getOrCreateDreamtwirlStage(regionPosOptional.get());
            return Optional.of(stage);
        }
        return Optional.empty();
    }

    public Optional<RegionPos> findUnusedRegionPos() {
        int MAX_RADIUS = 100;
        for (int radius = 0; radius < MAX_RADIUS; ++radius) {
            for (int i = 0; i < 1 + radius; ++i) {
                long candidateId;
                int randomZ;
                int randomX = this.random.nextInt(1 + 2 * radius) - radius;
                RegionPos candidatePos = new RegionPos(randomX * 2, (randomZ = this.random.nextInt(1 + 2 * radius) - radius) * 2);
                if (!this.regionPosInBounds(candidatePos) || this.basicStageDatas.containsKey(candidateId = candidatePos.id)) continue;
                return Optional.of(candidatePos);
            }
        }
        return Optional.empty();
    }

    public boolean regionPosInBounds(RegionPos regionPos) {
        int rx = regionPos.regionX;
        int rz = regionPos.regionZ;
        if (rx < this.minRegionX || this.maxRegionX < rx) {
            return false;
        }
        return rz >= this.minRegionZ && this.maxRegionZ >= rz;
    }

    public DreamtwirlStage getOrCreateDreamtwirlStage(RegionPos regionPos) {
        long id;
        if (!DreamtwirlStage.isIdAllowed(regionPos.id)) {
            MirthdewEncore.LOGGER.info("Created a Dreamtwirl with non-even region coordinates, this is probably fine, but shouldn't be possible???");
        }
        if (this.dreamtwirls.containsKey(id = regionPos.id)) {
            return this.dreamtwirls.get(id);
        }
        BasicStageData basicStageData = this.getOrCreateBasicStageData(regionPos);
        DreamtwirlStage dreamtwirlStage = this.createNewSavedStageData(basicStageData);
        this.dreamtwirls.put(id, dreamtwirlStage);
        this.setDirty();
        return dreamtwirlStage;
    }

    public boolean deleteDreamtwirlStage(RegionPos regionPos) {
        long id = regionPos.id;
        boolean deleted = false;
        if (this.basicStageDatas.containsKey(id)) {
            this.basicStageDatas.remove(id);
            deleted = true;
        }
        this.getDreamtwirlIfPresent(id);
        if (this.dreamtwirls.containsKey(id)) {
            this.dreamtwirls.remove(id).setRemoved(true);
            deleted = true;
        }
        if (deleted) {
            this.clearCache();
            this.setDirty();
        }
        return deleted;
    }

    public BasicStageData getOrCreateBasicStageData(RegionPos regionPos) {
        long id = regionPos.id;
        if (this.basicStageDatas.containsKey(id)) {
            return this.basicStageDatas.get(id);
        }
        BasicStageData basicStageData = new BasicStageData(regionPos.id, this.level.getGameTime());
        this.basicStageDatas.put(id, basicStageData);
        this.setDirty();
        return basicStageData;
    }

    public DreamtwirlStage getExistingSavedStageData(BasicStageData basicStageData) {
        String name = DreamtwirlStage.nameFor(basicStageData.getRegionPos());
        SavedData.Factory<DreamtwirlStage> factory = DreamtwirlStage.getPersistentStateType(this.level, basicStageData);
        return (DreamtwirlStage)this.level.getDataStorage().computeIfAbsent(factory, name);
    }

    public DreamtwirlStage createNewSavedStageData(BasicStageData basicStageData) {
        String name = DreamtwirlStage.nameFor(basicStageData.getRegionPos());
        SavedData.Factory<DreamtwirlStage> factory = DreamtwirlStage.getPersistentStateType(this.level, basicStageData);
        DreamtwirlStage stage = (DreamtwirlStage)((Object)factory.constructor().get());
        this.level.getDataStorage().set(name, (SavedData)stage);
        return stage;
    }

    @Nullable
    public static DreamtwirlStageManager getDreamtwirlStageManager(Level level) {
        DreamtwirlLevelAttachment DTWA = DreamtwirlLevelAttachment.fromLevel(level);
        if (DTWA == null) {
            return null;
        }
        return DTWA.getDreamtwirlStageManager();
    }

    @Nullable
    public static DreamtwirlStageManager getMainDreamtwirlStageManager(MinecraftServer server) {
        ServerLevel dreamtwirlLevel = server.getLevel(MirthdewEncoreDimensions.DREAMTWIRL_WORLD);
        if (dreamtwirlLevel == null) {
            return null;
        }
        return DreamtwirlStageManager.getDreamtwirlStageManager((Level)dreamtwirlLevel);
    }

    @Nullable
    public static DreamtwirlStage getStage(Level level, RegionPos regionPos) {
        DreamtwirlStageManager dsm = DreamtwirlStageManager.getDreamtwirlStageManager(level);
        if (dsm != null) {
            return dsm.getDreamtwirlIfPresent(regionPos);
        }
        return null;
    }

    @Nullable
    public static DreamtwirlStage getStage(Level level, BlockPos pos) {
        return DreamtwirlStageManager.getStage(level, RegionPos.fromBlockPos(pos));
    }

    @Nullable
    public static DreamtwirlStage getStage(Level level, long stageId) {
        return DreamtwirlStageManager.getStage(level, new RegionPos(stageId));
    }

    public boolean setRegionBounds(int minX, int minZ, int maxX, int maxZ) {
        if (minX < -58593) {
            minX = -58593;
        }
        if (minZ < -58593) {
            minZ = -58593;
        }
        if (maxX > 58592) {
            minX = 58592;
        }
        if (maxZ > 58592) {
            maxZ = 58592;
        }
        if (minX > maxX || minZ > maxZ) {
            return false;
        }
        this.minRegionX = minX;
        this.minRegionZ = minZ;
        this.maxRegionX = maxX;
        this.maxRegionZ = maxZ;
        this.setDirty();
        return true;
    }

    public int getMinRegionX() {
        return this.minRegionX;
    }

    public int getMinRegionZ() {
        return this.minRegionZ;
    }

    public int getMaxRegionX() {
        return this.maxRegionX;
    }

    public int getMaxRegionZ() {
        return this.maxRegionZ;
    }
}

