/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.play.DreamtwirlBorder;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityAttachment;
import phanastrae.mirthdew_encore.entity.effect.MirthdewEncoreStatusEffects;
import phanastrae.mirthdew_encore.mixin.ProjectileAccessor;
import phanastrae.mirthdew_encore.util.RegionPos;
import phanastrae.mirthdew_encore.world.dimension.MirthdewEncoreDimensions;

public class EntityDreamtwirlData {
    private final Entity entity;
    boolean inDreamtwirl = false;
    @Nullable
    RegionPos dreamtwirlRegion;

    public EntityDreamtwirlData(Entity entity) {
        this.entity = entity;
    }

    public void tick() {
        Level world = this.entity.level();
        if (!world.isClientSide()) {
            RegionPos entityRegion;
            DreamtwirlLevelAttachment DTWA = DreamtwirlLevelAttachment.fromLevel(world);
            boolean nowInDreamtwirl = DTWA != null;
            RegionPos regionPos = entityRegion = nowInDreamtwirl ? RegionPos.fromEntity(this.entity) : null;
            if (this.inDreamtwirl != nowInDreamtwirl) {
                this.setDreamtwirlRegion(entityRegion);
            }
            if (!nowInDreamtwirl) {
                return;
            }
            if (world.getGameTime() % 80L == 0L) {
                this.applyDreamtwirlEffects();
            }
            if (!this.shouldIgnoreBorder()) {
                DreamtwirlBorder dreamtwirlBorder = DTWA.getDreamtwirlBorder(this.dreamtwirlRegion);
                boolean touchingBorder = dreamtwirlBorder != null && dreamtwirlBorder.entityTouchingBorder(this.entity);
                DreamtwirlStageManager dreamtwirlStageManager = DreamtwirlStageManager.getDreamtwirlStageManager(world);
                if (dreamtwirlStageManager != null) {
                    DreamtwirlStage newStage = dreamtwirlStageManager.getDreamtwirlIfPresent(entityRegion);
                    if (newStage == null || newStage.isDeletingSelf()) {
                        touchingBorder = true;
                    } else if (!Objects.equals(this.dreamtwirlRegion, entityRegion)) {
                        if (this.canJoinRegion(entityRegion)) {
                            this.setDreamtwirlRegion(entityRegion);
                        } else {
                            touchingBorder = true;
                        }
                    }
                }
                if (touchingBorder) {
                    if (this.canLeave() && this.leaveDreamtwirl(false)) {
                        return;
                    }
                    Entity entity = this.entity;
                    if (entity instanceof Projectile) {
                        BlockHitResult hitResult;
                        Projectile projectileEntity = (Projectile)entity;
                        if (dreamtwirlBorder != null && (hitResult = dreamtwirlBorder.voxelShape.clip(this.entity.position(), this.entity.position().add(this.entity.getDeltaMovement()), BlockPos.containing((Position)this.entity.position()))) != null && !hitResult.getType().equals((Object)HitResult.Type.MISS)) {
                            ((ProjectileAccessor)projectileEntity).invokeOnHit((HitResult)hitResult);
                        }
                    }
                }
            }
        }
    }

    public void applyDreamtwirlEffects() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MirthdewEncoreStatusEffects.DREAMY_DIET_ENTRY, 200, 0, true, true));
            livingEntity.addEffect(new MobEffectInstance(MirthdewEncoreStatusEffects.MIRTHFUL_ENTRY, 200, 0, true, true));
        }
    }

    public boolean isInDreamtwirl() {
        return this.inDreamtwirl;
    }

    @Nullable
    public RegionPos getDreamtwirlRegion() {
        return this.dreamtwirlRegion;
    }

    public boolean isInDreamtwirlRegion(RegionPos dreamtwirlRegion) {
        return dreamtwirlRegion.equals(this.dreamtwirlRegion);
    }

    public boolean canJoinRegion(RegionPos regionPos) {
        return true;
    }

    public boolean joinDreamtwirl(RegionPos dreamtwirlRegion) {
        if (this.isInDreamtwirlRegion(dreamtwirlRegion)) {
            return false;
        }
        Vec3 vec3d = new Vec3((double)dreamtwirlRegion.getCenterX(), 64.0, (double)dreamtwirlRegion.getCenterZ());
        DimensionTransition teleportTarget = this.createTeleportTarget(MirthdewEncoreDimensions.DREAMTWIRL_WORLD, vec3d);
        if (teleportTarget == null) {
            return false;
        }
        if (EntityDreamtwirlData.teleportEntity(this.entity, teleportTarget)) {
            this.setDreamtwirlRegion(dreamtwirlRegion);
            this.applyDreamtwirlEffects();
            return true;
        }
        return false;
    }

    public boolean leaveDreamtwirl(boolean force) {
        DimensionTransition teleportTarget;
        if (!this.isInDreamtwirl() && !force) {
            return false;
        }
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            teleportTarget = serverPlayerEntity.findRespawnPositionAndUseSpawnBlock(false, DimensionTransition.DO_NOTHING);
        } else {
            Level currentWorld = this.entity.level();
            if (!(currentWorld instanceof ServerLevel)) {
                return false;
            }
            ResourceKey targetKey = Level.OVERWORLD;
            MinecraftServer server = currentWorld.getServer();
            ServerLevel targetWorld = server.getLevel(targetKey);
            if (targetWorld == null) {
                return false;
            }
            BlockPos blockPos = targetWorld.getSharedSpawnPos();
            Vec3 vec3d = this.entity.adjustSpawnLocation(targetWorld, blockPos).getBottomCenter();
            teleportTarget = this.createTeleportTarget(targetWorld, vec3d);
        }
        if (EntityDreamtwirlData.teleportEntity(this.entity, teleportTarget)) {
            this.setDreamtwirlRegion(null);
            return true;
        }
        return false;
    }

    public boolean shouldIgnoreBorder() {
        return this.entity.isSpectator();
    }

    public boolean canLeave() {
        return this.entity.canUsePortal(true) && this.entity instanceof Player;
    }

    public void setDreamtwirlRegion(@Nullable RegionPos region) {
        this.dreamtwirlRegion = region;
        this.inDreamtwirl = region != null;
    }

    public static VoxelShape addCollisionsTo(@Nullable VoxelShape original, Entity entity) {
        DreamtwirlLevelAttachment DTWA = DreamtwirlLevelAttachment.fromLevel(entity.level());
        if (DTWA == null) {
            return original;
        }
        RegionPos regionPos = RegionPos.fromEntity(entity);
        DreamtwirlBorder dreamtwirlBorder = DTWA.getDreamtwirlBorder(regionPos);
        if (dreamtwirlBorder == null) {
            return original;
        }
        VoxelShape newShape = dreamtwirlBorder.voxelShape;
        if (original == null) {
            return newShape;
        }
        return Shapes.joinUnoptimized((VoxelShape)original, (VoxelShape)newShape, (BooleanOp)BooleanOp.OR);
    }

    public static boolean joinDreamtwirl(Entity entity, RegionPos dreamtwirlRegion) {
        MirthdewEncoreEntityAttachment MEA = MirthdewEncoreEntityAttachment.fromEntity(entity);
        return MEA.getDreamtwirlEntityData().joinDreamtwirl(dreamtwirlRegion);
    }

    public static boolean leaveDreamtwirl(Entity entity) {
        MirthdewEncoreEntityAttachment MEA = MirthdewEncoreEntityAttachment.fromEntity(entity);
        return MEA.getDreamtwirlEntityData().leaveDreamtwirl(false);
    }

    public static boolean teleportEntity(Entity entity, DimensionTransition teleportTarget) {
        Level currentWorld = entity.level();
        if (!(currentWorld instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)currentWorld;
        MinecraftServer server = currentWorld.getServer();
        ServerLevel targetWorld = teleportTarget.newLevel();
        if (server.isLevelEnabled((Level)targetWorld) && (targetWorld.dimension() == serverWorld.dimension() || entity.canChangeDimensions((Level)serverWorld, (Level)targetWorld))) {
            entity.fallDistance = 0.0f;
            entity.changeDimension(teleportTarget);
            return true;
        }
        return false;
    }

    @Nullable
    public DimensionTransition createTeleportTarget(ResourceKey<Level> worldKey, Vec3 position) {
        Level currentWorld = this.entity.level();
        if (!(currentWorld instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)currentWorld;
        MinecraftServer server = currentWorld.getServer();
        ServerLevel targetWorld = server.getLevel(worldKey);
        if (targetWorld == null) {
            return null;
        }
        return this.createTeleportTarget(targetWorld, position);
    }

    public DimensionTransition createTeleportTarget(ServerLevel targetWorld, Vec3 position) {
        return new DimensionTransition(targetWorld, position, Vec3.ZERO, this.entity.getYRot(), this.entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }
}

