/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import phanastrae.mirthdew_encore.util.RegionPos;

public class BasicStageData {
    public static final String KEY_ID = "Id";
    public static final String KEY_TIMESTAMP = "Timestamp";
    public static final String KEY_DELETING_SELF = "is_deleting_self";
    private final long id;
    private final RegionPos regionPos;
    private final long timestamp;
    private boolean isDeletingSelf;

    public BasicStageData(long id, long timestamp) {
        this.id = id;
        this.regionPos = new RegionPos(id);
        this.timestamp = timestamp;
        this.isDeletingSelf = false;
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        nbt.putLong(KEY_ID, this.getId());
        nbt.putLong(KEY_TIMESTAMP, this.getTimestamp());
        nbt.putBoolean(KEY_DELETING_SELF, this.isDeletingSelf);
        return nbt;
    }

    public static BasicStageData fromNbt(CompoundTag nbt) {
        long id = nbt.getLong(KEY_ID);
        long timestamp = nbt.getLong(KEY_TIMESTAMP);
        BasicStageData bsd = new BasicStageData(id, timestamp);
        bsd.isDeletingSelf = nbt.contains(KEY_DELETING_SELF, 1) ? nbt.getBoolean(KEY_DELETING_SELF) : false;
        return bsd;
    }

    public void setDeletingSelf(boolean deletingSelf) {
        this.isDeletingSelf = deletingSelf;
    }

    public boolean isDeletingSelf() {
        return this.isDeletingSelf;
    }

    public long getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public RegionPos getRegionPos() {
        return this.regionPos;
    }

    public long getAgeInTicks(long levelTime) {
        return levelTime - this.timestamp;
    }

    public Component getAgeTextComponentFromLevelTime(long levelTime) {
        return BasicStageData.getAgeTextComponent(this.getAgeInTicks(levelTime));
    }

    public static Component getAgeTextComponent(long ageInTicks) {
        long ageInSeconds = ageInTicks / 20L;
        long ageInMinutes = ageInSeconds / 60L;
        long ageInHours = ageInMinutes / 60L;
        if (ageInHours >= 1L) {
            return Component.translatable((String)"mirthdew_encore.displays.hours_minutes", (Object[])new Object[]{ageInHours, ageInMinutes % 60L});
        }
        if (ageInMinutes >= 1L) {
            return Component.translatable((String)"mirthdew_encore.displays.minutes_seconds", (Object[])new Object[]{ageInMinutes, ageInSeconds % 60L});
        }
        if (ageInSeconds >= 1L) {
            return Component.translatable((String)"mirthdew_encore.displays.seconds", (Object[])new Object[]{ageInSeconds});
        }
        return Component.translatable((String)"mirthdew_encore.displays.ticks", (Object[])new Object[]{ageInTicks});
    }
}

