/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.acherune;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.entity.SlumbersocketBlockEntity;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.StageAcherunes;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;
import phanastrae.mirthdew_encore.util.BlockPosDimensional;

public class Acherune {
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_ID = "id";
    public static final String KEY_POS_X = "x";
    public static final String KEY_POS_Y = "y";
    public static final String KEY_POS_Z = "z";
    public static final String KEY_LINKED_POS = "linked_pos";
    private final AcheruneId id;
    private BlockPos pos;
    @Nullable
    private BlockPosDimensional linkedPos = null;

    public Acherune(BlockPos pos, AcheruneId id) {
        this.pos = pos.immutable();
        this.id = id;
    }

    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.putLong(KEY_TIMESTAMP, this.id.timestamp());
        nbt.putLong(KEY_ID, this.id.id());
        nbt.putInt(KEY_POS_X, this.pos.getX());
        nbt.putInt(KEY_POS_Y, this.pos.getY());
        nbt.putInt(KEY_POS_Z, this.pos.getZ());
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (this.linkedPos != null) {
            BlockPosDimensional.CODEC.encodeStart((DynamicOps)registryops, (Object)this.linkedPos).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to encode location for Acherune: '{}'", st)).ifPresent(bpdTag -> nbt.put(KEY_LINKED_POS, bpdTag));
        }
        return nbt;
    }

    public static Acherune fromNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        long timestamp = nbt.getLong(KEY_TIMESTAMP);
        long id = nbt.getLong(KEY_ID);
        AcheruneId aId = new AcheruneId(timestamp, id);
        int x = nbt.getInt(KEY_POS_X);
        int y = nbt.getInt(KEY_POS_Y);
        int z = nbt.getInt(KEY_POS_Z);
        BlockPos pos = new BlockPos(x, y, z);
        Acherune acherune = new Acherune(pos, aId);
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (nbt.contains(KEY_LINKED_POS, 10)) {
            BlockPosDimensional.CODEC.parse((DynamicOps)registryops, (Object)nbt.get(KEY_LINKED_POS)).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to parse location for Acherune: '{}'", st)).ifPresent(acherune::setLinkedPos);
        }
        return acherune;
    }

    public AcheruneId getId() {
        return this.id;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setLinkedPos(@Nullable BlockPosDimensional linkedPos) {
        this.linkedPos = linkedPos;
    }

    @Nullable
    public BlockPosDimensional getLinkedPos() {
        return this.linkedPos;
    }

    public boolean isLinkedTo(BlockPos pos, @Nullable Level level) {
        if (this.linkedPos == null || level == null) {
            return false;
        }
        return pos.equals((Object)this.linkedPos.getPos()) && level.dimension().location().equals((Object)this.linkedPos.dimensionId());
    }

    public boolean validateLinkedPos(MinecraftServer server, StageAcherunes stageAcherunes) {
        SlumbersocketBlockEntity blockEntity;
        ItemStack eye;
        if (this.linkedPos == null) {
            return false;
        }
        Level level = this.linkedPos.getLevel(server);
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        BlockPos linkedBlockPos = this.linkedPos.getPos();
        BlockEntity blockEntity2 = level.getBlockEntity(linkedBlockPos);
        if (blockEntity2 instanceof SlumbersocketBlockEntity && (eye = (blockEntity = (SlumbersocketBlockEntity)blockEntity2).getHeldItem()).is(MirthdewEncoreItems.SLUMBERING_EYE) && eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)) {
            LinkedAcheruneComponent lac = (LinkedAcheruneComponent)eye.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
            if (this.getId().equals(lac.getAcheruneId())) {
                return true;
            }
        }
        this.setLinkedPos(null);
        stageAcherunes.setDirty();
        return false;
    }

    public Optional<BlockPos> validateLinke(MinecraftServer server, StageAcherunes stageAcherunes) {
        SlumbersocketBlockEntity socket;
        ItemStack eye;
        if (this.linkedPos == null) {
            return Optional.empty();
        }
        Level level = this.linkedPos.getLevel(server);
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        BlockPos linkedBlockPos = this.linkedPos.getPos();
        BlockEntity blockEntity = level.getBlockEntity(linkedBlockPos);
        if (blockEntity instanceof SlumbersocketBlockEntity && (eye = (socket = (SlumbersocketBlockEntity)blockEntity).getHeldItem()).is(MirthdewEncoreItems.SLUMBERING_EYE) && eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)) {
            LinkedAcheruneComponent lac = (LinkedAcheruneComponent)eye.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
            if (this.getId().equals(lac.getAcheruneId())) {
                return Optional.of(socket.getTargetPos());
            }
        }
        this.setLinkedPos(null);
        stageAcherunes.setDirty();
        return Optional.empty();
    }

    public Optional<BlockPos> getTargetPos(MinecraftServer server, StageAcherunes stageAcherunes) {
        SlumbersocketBlockEntity socket;
        ItemStack eye;
        if (this.linkedPos == null) {
            return Optional.empty();
        }
        Level level = this.linkedPos.getLevel(server);
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        BlockPos linkedBlockPos = this.linkedPos.getPos();
        BlockEntity blockEntity = level.getBlockEntity(linkedBlockPos);
        if (blockEntity instanceof SlumbersocketBlockEntity && (eye = (socket = (SlumbersocketBlockEntity)blockEntity).getHeldItem()).is(MirthdewEncoreItems.SLUMBERING_EYE) && eye.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE)) {
            LinkedAcheruneComponent lac = (LinkedAcheruneComponent)eye.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
            if (this.getId().equals(lac.getAcheruneId())) {
                return Optional.of(socket.getTargetPos());
            }
        }
        this.setLinkedPos(null);
        stageAcherunes.setDirty();
        return Optional.empty();
    }

    public record AcheruneId(long timestamp, long id) {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AcheruneId) {
                AcheruneId ot = (AcheruneId)o;
                return this.timestamp == ot.timestamp && this.id == ot.id;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.timestamp ^ this.id);
        }
    }
}

