/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.design.graph;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.StageDesignData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.Room;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomDoor;
import phanastrae.mirthdew_encore.util.graph.DirectedEdge;
import phanastrae.mirthdew_encore.util.graph.DirectedGraph;

public class RoomGraph {
    public static final String KEY_GRAPH = "graph";
    public static final String KEY_ROOM_IDS = "room_ids";
    public static final String KEY_DOOR_IDS = "door_ids";
    public static final String KEY_NODE_IDS = "node_ids";
    private DirectedGraph graph = new DirectedGraph();
    private final Map<RoomDoor.RoomDoorId, Long> doorToIdMap = new Object2ObjectOpenHashMap();
    private final Map<Long, RoomDoor.RoomDoorId> idToDoorMap = new Object2ObjectOpenHashMap();

    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DirectedGraph.CODEC.encodeStart((DynamicOps)registryops, (Object)this.graph).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to encode directed graph for Room Graph: '{}'", st)).ifPresent(tag -> nbt.put(KEY_GRAPH, tag));
        ObjectArrayList roomIds = new ObjectArrayList();
        ObjectArrayList doorIds = new ObjectArrayList();
        ObjectArrayList nodeIds = new ObjectArrayList();
        this.doorToIdMap.forEach((arg_0, arg_1) -> RoomGraph.lambda$writeNbt$2((List)roomIds, (List)doorIds, (List)nodeIds, arg_0, arg_1));
        nbt.putLongArray(KEY_ROOM_IDS, (List)roomIds);
        nbt.putIntArray(KEY_DOOR_IDS, (List)doorIds);
        nbt.putLongArray(KEY_NODE_IDS, (List)nodeIds);
        return nbt;
    }

    public CompoundTag readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        RegistryOps registryops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (nbt.contains(KEY_GRAPH, 10)) {
            DirectedGraph.CODEC.parse((DynamicOps)registryops, (Object)nbt.get(KEY_GRAPH)).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to parse directed graph for Room Graph: '{}'", st)).ifPresent(graph -> {
                this.graph = graph;
            });
        }
        this.clearPairs();
        if (nbt.contains(KEY_ROOM_IDS, 12) && nbt.contains(KEY_DOOR_IDS, 11) && nbt.contains(KEY_NODE_IDS, 12)) {
            long[] rooms = nbt.getLongArray(KEY_ROOM_IDS);
            int[] doors = nbt.getIntArray(KEY_DOOR_IDS);
            long[] nodes = nbt.getLongArray(KEY_NODE_IDS);
            if (rooms.length == doors.length && doors.length == nodes.length) {
                for (int i = 0; i < rooms.length; ++i) {
                    this.addIdPair(nodes[i], new RoomDoor.RoomDoorId(doors[i], rooms[i]));
                }
            }
        }
        return nbt;
    }

    public void addRoom(StageDesignData designData, Room room, RandomSource random) {
        ObjectArrayList newNodes = new ObjectArrayList();
        for (RoomDoor door : room.getDoors()) {
            long id = this.graph.getNextNodeId(random);
            newNodes.add(id);
            this.addIdPair(id, door.getRoomDoorId());
        }
        Iterator<RoomDoor> iterator = newNodes.iterator();
        while (iterator.hasNext()) {
            RoomDoor door;
            long start = (Long)((Object)iterator.next());
            RoomDoor.RoomDoorId node = this.idToDoorMap.get(start);
            if (node == null || (door = designData.getDoor(node)) == null || !door.getDoorType().isEntrance) continue;
            Iterator iterator2 = newNodes.iterator();
            while (iterator2.hasNext()) {
                RoomDoor door2;
                RoomDoor.RoomDoorId node2;
                long end = (Long)iterator2.next();
                if (start == end || (node2 = this.idToDoorMap.get(end)) == null || (door2 = designData.getDoor(node2)) == null || !door2.getDoorType().isExit) continue;
                this.addNodesWithEdge(node, node2, random);
            }
        }
    }

    public void removeRoom(Room room) {
        for (RoomDoor door : room.getDoors()) {
            if (!this.doorToIdMap.containsKey(door.getRoomDoorId())) continue;
            long id = this.doorToIdMap.get(door.getRoomDoorId());
            this.graph.removeNode(id);
            this.removePair(id);
        }
    }

    public void removePair(long id) {
        if (this.idToDoorMap.containsKey(id)) {
            RoomDoor.RoomDoorId rdId = this.idToDoorMap.remove(id);
            this.doorToIdMap.remove(rdId);
        }
    }

    public void clearPairs() {
        this.idToDoorMap.clear();
        this.doorToIdMap.clear();
    }

    public void addIdPair(long id, RoomDoor.RoomDoorId roomDoorId) {
        if (!this.idToDoorMap.containsKey(id)) {
            this.idToDoorMap.put(id, roomDoorId);
        }
        if (!this.doorToIdMap.containsKey(roomDoorId)) {
            this.doorToIdMap.put(roomDoorId, id);
        }
    }

    @Nullable
    public RoomDoor.RoomDoorId getDoorNode(long id) {
        return this.idToDoorMap.getOrDefault(id, null);
    }

    public void addEdge(long start, long end, RandomSource random) {
        this.graph.addEdge(start, end, random);
    }

    public void addNodesWithEdge(RoomDoor.RoomDoorId start, RoomDoor.RoomDoorId end, RandomSource random) {
        if (this.doorToIdMap.containsKey(start) && this.doorToIdMap.containsKey(end)) {
            this.addEdge(this.doorToIdMap.get(start), this.doorToIdMap.get(end), random);
        }
    }

    public Optional<RoomDoor.RoomDoorId> getNode(RoomDoor door) {
        long id;
        if (this.doorToIdMap.containsKey(door.getRoomDoorId()) && this.idToDoorMap.containsKey(id = this.doorToIdMap.get(door.getRoomDoorId()).longValue())) {
            RoomDoor.RoomDoorId node = this.idToDoorMap.get(id);
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public Optional<RoomDoor.RoomDoorId> getRandomUnfilledExitDoorNode(StageDesignData designData, RandomSource random) {
        List<RoomDoor.RoomDoorId> emptyDoors = this.idToDoorMap.values().stream().filter(doorNode -> {
            RoomDoor door = designData.getDoor((RoomDoor.RoomDoorId)doorNode);
            return door != null && !door.isConnected() && door.getDoorType().isExit;
        }).toList();
        if (emptyDoors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(emptyDoors.get(random.nextInt(emptyDoors.size())));
    }

    public DirectedGraph getGraph() {
        return this.graph;
    }

    public void forEachConnectedEndpoint(RoomDoor.RoomDoorId startDoor, Consumer<RoomDoor.RoomDoorId> endNodeConsumer) {
        if (!this.doorToIdMap.containsKey(startDoor)) {
            return;
        }
        long startId = this.doorToIdMap.get(startDoor);
        List<Long> out = this.graph.getOrCreateNode(startId).getOutgoingEdges();
        if (out != null) {
            out.forEach(edgeId -> {
                long endId;
                RoomDoor.RoomDoorId endNode;
                DirectedEdge edge = this.graph.getEdge((long)edgeId);
                if (edge != null && (endNode = this.getDoorNode(endId = edge.getEndId())) != null) {
                    endNodeConsumer.accept(endNode);
                }
            });
        }
    }

    public void forEachConnectedStartpoint(RoomDoor.RoomDoorId endDoor, Consumer<RoomDoor.RoomDoorId> startNodeConsumer) {
        if (!this.doorToIdMap.containsKey(endDoor)) {
            return;
        }
        long endId = this.doorToIdMap.get(endDoor);
        List<Long> in = this.graph.getOrCreateNode(endId).getIncomingEdges();
        if (in != null) {
            in.forEach(edgeId -> {
                long startId;
                RoomDoor.RoomDoorId startNode;
                DirectedEdge edge = this.graph.getEdge((long)edgeId);
                if (edge != null && (startNode = this.getDoorNode(startId = edge.getStartId())) != null) {
                    startNodeConsumer.accept(startNode);
                }
            });
        }
    }

    public Map<RoomDoor.RoomDoorId, Long> getDoorToIdMap() {
        return this.doorToIdMap;
    }

    public Map<Long, RoomDoor.RoomDoorId> getIdToDoorMap() {
        return this.idToDoorMap;
    }

    private static /* synthetic */ void lambda$writeNbt$2(List roomIds, List doorIds, List nodeIds, RoomDoor.RoomDoorId roomDoorId, Long nodeId) {
        roomIds.add(roomDoorId.roomId());
        doorIds.add(roomDoorId.doorId());
        nodeIds.add(nodeId);
    }
}

