/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.design.room;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public class RoomDoor {
    public static final StringRepresentable.StringRepresentableCodec<DoorType> DOOR_TYPE_CODEC = StringRepresentable.fromEnum(DoorType::values);
    public static final StringRepresentable.StringRepresentableCodec<FrontAndTop> FRONT_AND_TOP_CODEC = StringRepresentable.fromEnum(FrontAndTop::values);
    public static final Codec<RoomDoor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("door_id", (Object)0).forGetter(RoomDoor::getDoorId), (App)Codec.LONG.optionalFieldOf("room_id", (Object)0L).forGetter(RoomDoor::getRoomId), (App)DOOR_TYPE_CODEC.optionalFieldOf("door_type", (Object)DoorType.TWOWAY).forGetter(RoomDoor::getDoorType), (App)Codec.STRING.optionalFieldOf("target_lychseal", (Object)"").forGetter(RoomDoor::getTargetLychseal), (App)BlockPos.CODEC.fieldOf("pos").forGetter(RoomDoor::getPos), (App)FRONT_AND_TOP_CODEC.fieldOf("orientation").forGetter(RoomDoor::getOrientation), (App)Codec.BOOL.optionalFieldOf("connected", (Object)false).forGetter(RoomDoor::isConnected)).apply((Applicative)instance, RoomDoor::new));
    private final int doorId;
    private final long roomId;
    private final DoorType doorType;
    private final String targetLychseal;
    private BlockPos pos;
    private FrontAndTop orientation;
    private boolean connected;

    public RoomDoor(int doorId, long roomId, DoorType doorType, String targetLychseal, BlockPos pos, FrontAndTop orientation, boolean connected) {
        this.doorId = doorId;
        this.roomId = roomId;
        this.doorType = doorType;
        this.targetLychseal = targetLychseal;
        this.pos = pos;
        this.orientation = orientation;
        this.connected = connected;
    }

    public static RoomDoor fromNbt(int doorId, long roomId, CompoundTag nbt, BlockPos pos, FrontAndTop orientation, boolean connected) {
        DoorType doorType = nbt.contains("door_type") ? DoorType.byName(nbt.getString("door_type")).orElse(DoorType.TWOWAY) : DoorType.TWOWAY;
        String targetLychseal = nbt.contains("target_lychseal") ? nbt.getString("target_lychseal") : "";
        return new RoomDoor(doorId, roomId, doorType, targetLychseal, pos, orientation, connected);
    }

    public void translate(int x, int y, int z) {
        this.pos = this.pos.offset(x, y, z);
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public FrontAndTop getOrientation() {
        return this.orientation;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public DoorType getDoorType() {
        return this.doorType;
    }

    public String getTargetLychseal() {
        return this.targetLychseal;
    }

    public int getDoorId() {
        return this.doorId;
    }

    public long getRoomId() {
        return this.roomId;
    }

    public RoomDoorId getRoomDoorId() {
        return new RoomDoorId(this.doorId, this.roomId);
    }

    public static enum DoorType implements StringRepresentable
    {
        ENTRANCE_ONLY("entrance", true, false),
        EXIT_ONLY("exit", false, true),
        TWOWAY("both", true, true);

        private final String name;
        public final boolean isEntrance;
        public final boolean isExit;

        private DoorType(String name, boolean isEntrance, boolean isExit) {
            this.name = name;
            this.isEntrance = isEntrance;
            this.isExit = isExit;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Optional<DoorType> byName(String name) {
            return Arrays.stream(DoorType.values()).filter(p_59461_ -> p_59461_.getSerializedName().equals(name)).findFirst();
        }

        public Component getTranslatedName() {
            return Component.translatable((String)("mirthdew_encore.door_type." + this.name));
        }
    }

    public record RoomDoorId(int doorId, long roomId) {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof RoomDoorId) {
                RoomDoorId ot = (RoomDoorId)o;
                return this.doorId == ot.doorId && this.roomId == ot.roomId;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.roomId ^ ((long)this.doorId << 3) * 137L);
        }
    }
}

