/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.design.room;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.util.RandomSource;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.ParentedRoomDoor;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.Room;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomDoor;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room_source.RoomSource;

public class SourcedRoom {
    private final Room room;
    private final RoomSource roomSource;

    public SourcedRoom(Room room, RoomSource roomSource) {
        this.room = room;
        this.roomSource = roomSource;
    }

    public Optional<ParentedRoomDoor> getRandomEmptyDoor(RandomSource random) {
        return this.getRandomDoorMatching(random, door -> !door.isConnected());
    }

    public Optional<ParentedRoomDoor> getRandomEmptyExit(RandomSource random) {
        return this.getRandomDoorMatching(random, door -> !door.isConnected() && door.getDoorType().isExit);
    }

    public Optional<RoomDoor> getRandomEmptyEntranceMatching(RandomSource random, FrontAndTop orientation) {
        Direction targetOrientation = orientation.front().getOpposite();
        return this.getRandomDoorMatching(random, door -> !door.isConnected() && door.getDoorType().isEntrance && door.getOrientation().front().equals((Object)targetOrientation)).map(ParentedRoomDoor::getDoor);
    }

    public Optional<ParentedRoomDoor> getRandomDoorMatching(RandomSource random, Predicate<RoomDoor> predicate) {
        List<RoomDoor> valid = this.getRoom().getDoors().stream().filter(predicate).toList();
        return this.getRandomDoorFrom(valid, random);
    }

    public Optional<ParentedRoomDoor> getRandomDoorFrom(List<RoomDoor> doors, RandomSource random) {
        if (doors.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ParentedRoomDoor(doors.get(random.nextInt(doors.size())), this.getRoom()));
    }

    public Room getRoom() {
        return this.room;
    }

    public RoomSource getRoomSource() {
        return this.roomSource;
    }
}

