/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.design.room_source;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.StageDesignData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.Room;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomDoor;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomLychseal;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.SourcedRoom;
import phanastrae.mirthdew_encore.dreamtwirl.stage.plan.room.RoomType;
import phanastrae.mirthdew_encore.mixin.ListPoolElementAccessor;
import phanastrae.mirthdew_encore.mixin.SinglePoolElementAccesor;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreRegistries;

public class RoomSource {
    public static final String KEY_ROOM_TYPE = "room_type";
    public static final String KEY_ATTEMPT_ROOMS = "attempt_rooms";
    public static final String KEY_FAILED_ROOMS = "failed_rooms";
    private final RoomType roomType;
    private final List<Room> attemptRooms;
    private final List<Room> failedRooms;

    public RoomSource(RoomType roomType) {
        this.roomType = roomType;
        this.attemptRooms = new ArrayList<Room>();
        this.failedRooms = new ArrayList<Room>();
    }

    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries, StructurePieceSerializationContext spsContext) {
        Registry roomTypeRegistry;
        ResourceLocation roomTypeKey;
        Optional roomTypeRegistryOptional = spsContext.registryAccess().registry(MirthdewEncoreRegistries.ROOM_TYPE_KEY);
        if (roomTypeRegistryOptional.isPresent() && (roomTypeKey = (roomTypeRegistry = (Registry)roomTypeRegistryOptional.get()).getKey((Object)this.roomType)) != null) {
            nbt.putString(KEY_ROOM_TYPE, roomTypeKey.toString());
        }
        ListTag attemptRoomList = new ListTag();
        for (Room room : this.attemptRooms) {
            attemptRoomList.add((Object)room.writeNbt(new CompoundTag(), registries, spsContext));
        }
        nbt.put(KEY_ATTEMPT_ROOMS, (Tag)attemptRoomList);
        ListTag failedRoomList = new ListTag();
        for (Room room : this.failedRooms) {
            failedRoomList.add((Object)room.writeNbt(new CompoundTag(), registries, spsContext));
        }
        nbt.put(KEY_FAILED_ROOMS, (Tag)failedRoomList);
        return nbt;
    }

    @Nullable
    public static RoomSource fromNbt(CompoundTag nbt, HolderLookup.Provider registries, StructurePieceSerializationContext spsContext) {
        Room room;
        CompoundTag tag;
        int i;
        if (!nbt.contains(KEY_ROOM_TYPE, 8)) {
            return null;
        }
        Optional roomTypeRegistryOptional = spsContext.registryAccess().registry(MirthdewEncoreRegistries.ROOM_TYPE_KEY);
        if (roomTypeRegistryOptional.isEmpty()) {
            return null;
        }
        Registry roomTypeRegistry = (Registry)roomTypeRegistryOptional.get();
        RoomType roomType = (RoomType)roomTypeRegistry.get(ResourceLocation.parse((String)nbt.getString(KEY_ROOM_TYPE)));
        if (roomType == null) {
            return null;
        }
        RoomSource source = new RoomSource(roomType);
        if (nbt.contains(KEY_ATTEMPT_ROOMS, 9)) {
            ListTag attemptRoomList = nbt.getList(KEY_ATTEMPT_ROOMS, 10);
            for (i = 0; i < attemptRoomList.size(); ++i) {
                tag = attemptRoomList.getCompound(i);
                room = Room.fromNbt(tag, registries, spsContext);
                if (room == null) continue;
                source.attemptRooms.add(room);
            }
        }
        if (nbt.contains(KEY_FAILED_ROOMS, 9)) {
            ListTag failedRoomList = nbt.getList(KEY_FAILED_ROOMS, 10);
            for (i = 0; i < failedRoomList.size(); ++i) {
                tag = failedRoomList.getCompound(i);
                room = Room.fromNbt(tag, registries, spsContext);
                if (room == null) continue;
                source.failedRooms.add(room);
            }
        }
        return source;
    }

    public Optional<SourcedRoom> tryGetRoom(long stageSeed, ChunkPos stageCenterPos, RandomSource random, ServerLevel serverLevel, StageDesignData designData) {
        if (!this.attemptRooms.isEmpty()) {
            Room room = this.attemptRooms.removeFirst();
            return Optional.of(new SourcedRoom(room, this));
        }
        if (!this.failedRooms.isEmpty()) {
            this.attemptRooms.addAll(this.failedRooms);
            this.failedRooms.clear();
        }
        return this.tryGenerateRoom(stageSeed, stageCenterPos, random, serverLevel, designData);
    }

    public Optional<SourcedRoom> tryGenerateRoom(long stageSeed, ChunkPos stageCenterPos, RandomSource random, ServerLevel serverLevel, StageDesignData designData) {
        Optional<PiecesContainer> piecesContainerOptional = RoomSource.tryMakePiecesContainer(serverLevel, random, stageSeed, stageCenterPos.getWorldPosition(), this.roomType);
        return piecesContainerOptional.map(piecesContainer -> {
            long roomId = designData.getNextRoomId();
            Room.RoomObjects objects = RoomSource.collectRoomObjects(piecesContainer, serverLevel.getStructureManager(), random, roomId);
            Room room = new Room(roomId, this.roomType, (PiecesContainer)piecesContainer, objects);
            return new SourcedRoom(room, this);
        });
    }

    public void acceptDiscardedRoom(Room discardedRoom) {
        this.failedRooms.add(discardedRoom);
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public static Optional<PiecesContainer> tryMakePiecesContainer(ServerLevel serverLevel, RandomSource random, long stageSeed, BlockPos pos, RoomType roomType) {
        return RoomSource.tryMakePiecesContainer(serverLevel, stageSeed ^ random.nextLong(), pos, roomType.maxDepth(), roomType.templatePool());
    }

    public static Optional<PiecesContainer> tryMakePiecesContainer(ServerLevel serverLevel, long seed, BlockPos pos, int maxDepth, ResourceLocation templatePool) {
        RegistryAccess registryAccess = serverLevel.registryAccess();
        Optional structureTemplateRegistryOptional = registryAccess.registry(Registries.TEMPLATE_POOL);
        if (structureTemplateRegistryOptional.isEmpty()) {
            return Optional.empty();
        }
        Registry structureTemplateRegistry = (Registry)structureTemplateRegistryOptional.get();
        Optional holderOptional = structureTemplateRegistry.getHolder(templatePool);
        if (holderOptional.isEmpty()) {
            return Optional.empty();
        }
        Holder startPool = (Holder)holderOptional.get();
        ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
        Structure.GenerationContext generationContext = new Structure.GenerationContext(registryAccess, chunkGenerator, chunkGenerator.getBiomeSource(), serverLevel.getChunkSource().randomState(), serverLevel.getStructureManager(), seed, new ChunkPos(pos), (LevelHeightAccessor)serverLevel, biome -> true);
        Optional genStubOptional = JigsawPlacement.addPieces((Structure.GenerationContext)generationContext, (Holder)startPool, Optional.empty(), (int)maxDepth, (BlockPos)pos, (boolean)false, Optional.empty(), (int)128, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
        return genStubOptional.map(generationStub -> generationStub.getPiecesBuilder().build());
    }

    public static Room.RoomObjects collectRoomObjects(PiecesContainer piecesContainer, StructureTemplateManager structureTemplateManager, RandomSource random, long roomId) {
        ObjectArrayList doors = new ObjectArrayList();
        int doorId = 0;
        ObjectArrayList seals = new ObjectArrayList();
        for (StructurePiece piece : piecesContainer.pieces()) {
            if (!(piece instanceof PoolElementStructurePiece)) continue;
            PoolElementStructurePiece poolStructurePiece = (PoolElementStructurePiece)piece;
            StructurePoolElement poolElement = poolStructurePiece.getElement();
            List<StructureTemplate.StructureBlockInfo> doorList = RoomSource.getDoorMarkerInfos(poolElement, structureTemplateManager, poolStructurePiece.getPosition(), piece.getRotation(), random);
            for (StructureTemplate.StructureBlockInfo info : doorList) {
                Optional<RoomDoor> doorOptional = RoomSource.getDoorFromInfo(info, doorId, roomId);
                if (!doorOptional.isPresent()) continue;
                doors.add(doorOptional.get());
                ++doorId;
            }
            List<StructureTemplate.StructureBlockInfo> sealList = RoomSource.getLychsealMarkerInfos(poolElement, structureTemplateManager, poolStructurePiece.getPosition(), piece.getRotation(), random);
            for (StructureTemplate.StructureBlockInfo info : sealList) {
                RoomSource.getLychsealFromInfo(info).ifPresent(((List)seals)::add);
            }
        }
        return new Room.RoomObjects((List<RoomDoor>)doors, (List<RoomLychseal>)seals);
    }

    public static List<StructureTemplate.StructureBlockInfo> getDoorMarkerInfos(StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        return RoomSource.getMarkerInfos(MirthdewEncoreBlocks.DOOR_MARKER, poolElement, structureTemplateManager, pos, rotation, random);
    }

    public static List<StructureTemplate.StructureBlockInfo> getGreaterAcheruneMarkerInfos(StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        return RoomSource.getMarkerInfos(MirthdewEncoreBlocks.GREATER_ACHERUNE_MARKER, poolElement, structureTemplateManager, pos, rotation, random);
    }

    public static List<StructureTemplate.StructureBlockInfo> getLychsealMarkerInfos(StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        return RoomSource.getMarkerInfos(MirthdewEncoreBlocks.LYCHSEAL_MARKER, poolElement, structureTemplateManager, pos, rotation, random);
    }

    public static List<StructureTemplate.StructureBlockInfo> getMarkerInfos(Block targetBlock, StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, RandomSource random) {
        if (poolElement instanceof SinglePoolElement) {
            SinglePoolElement singlePoolElement = (SinglePoolElement)poolElement;
            StructureTemplate structureTemplate = ((SinglePoolElementAccesor)singlePoolElement).invokeGetTemplate(structureTemplateManager);
            ObjectArrayList objectArrayList = structureTemplate.filterBlocks(pos, new StructurePlaceSettings().setRotation(rotation), targetBlock, true);
            Util.shuffle((List)objectArrayList, (RandomSource)random);
            objectArrayList.sort(Comparator.comparingInt(block -> (Integer)Optionull.mapOrDefault((Object)block.nbt(), nbt -> nbt.getInt("selection_priority"), (Object)0)).reversed());
            return objectArrayList;
        }
        if (poolElement instanceof ListPoolElement) {
            ListPoolElement listPoolElement = (ListPoolElement)poolElement;
            List<StructurePoolElement> elements = ((ListPoolElementAccessor)listPoolElement).getElements();
            return RoomSource.getMarkerInfos(targetBlock, elements.getFirst(), structureTemplateManager, pos, rotation, random);
        }
        return new ObjectArrayList();
    }

    private static Optional<RoomDoor> getDoorFromInfo(StructureTemplate.StructureBlockInfo info, int id, long roomId) {
        EnumProperty property;
        BlockState state = info.state();
        if (state.hasProperty((Property)(property = BlockStateProperties.ORIENTATION))) {
            FrontAndTop orientation = (FrontAndTop)state.getValue((Property)property);
            CompoundTag nbt = info.nbt();
            if (nbt == null) {
                return Optional.empty();
            }
            RoomDoor door = RoomDoor.fromNbt(id, roomId, nbt, info.pos(), orientation, false);
            return Optional.of(door);
        }
        return Optional.empty();
    }

    private static Optional<RoomLychseal> getLychsealFromInfo(StructureTemplate.StructureBlockInfo info) {
        EnumProperty property;
        BlockState state = info.state();
        if (state.hasProperty((Property)(property = BlockStateProperties.ORIENTATION))) {
            FrontAndTop orientation = (FrontAndTop)state.getValue((Property)property);
            CompoundTag nbt = info.nbt();
            if (nbt == null) {
                return Optional.empty();
            }
            RoomLychseal seal = RoomLychseal.fromNbt(nbt, info.pos(), orientation, false);
            return Optional.of(seal);
        }
        return Optional.empty();
    }
}

