/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.generate.destroy;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.EntityDreamtwirlData;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityAttachment;
import phanastrae.mirthdew_encore.util.RegionPos;
import phanastrae.mirthdew_encore.world.biome.MirthdewEncoreBiomes;

public class StageNuker {
    public static ChunkPos getChunkPosForProgress(RegionPos regionPos, int progress) {
        int cx = (progress %= 900) % 30;
        int cz = progress / 30;
        ChunkPos minChunkPos = regionPos.getMinChunkPos();
        return new ChunkPos(minChunkPos.x + cx + 1, minChunkPos.z + cz + 1);
    }

    public static void tryPreLoadChunk(ServerLevel level, ChunkPos chunkPos) {
        ServerChunkCache chunkSource = level.getChunkSource();
        chunkSource.addRegionTicket(TicketType.UNKNOWN, chunkPos, 0, (Object)chunkPos);
    }

    public static boolean tryClearChunk(ServerLevel level, ChunkPos chunkPos) {
        DreamtwirlLevelAttachment dla = DreamtwirlLevelAttachment.fromLevel((Level)level);
        if (dla == null) {
            MirthdewEncore.LOGGER.warn("Tried to clear chunks in a non-dreamtwirl level??? Cancelling.");
            return false;
        }
        DreamtwirlStageManager dsm = dla.getDreamtwirlStageManager();
        if (dsm == null) {
            MirthdewEncore.LOGGER.warn("Tried to clear chunks in a non-dreamtwirl level??? Cancelling.");
            return false;
        }
        ServerChunkCache chunkSource = level.getChunkSource();
        LevelChunk chunk = chunkSource.getChunkNow(chunkPos.x, chunkPos.z);
        if (chunk == null) {
            return false;
        }
        chunk.setUnsaved(true);
        List blockEntityPositions = chunk.getBlockEntities().keySet().stream().toList();
        for (BlockPos pos : blockEntityPositions) {
            chunk.setBlockState(pos, Blocks.AIR.defaultBlockState(), false);
        }
        RegionPos regionPos = RegionPos.fromChunkPos(chunkPos);
        ChunkPos regionMinChunkPos = regionPos.getMinChunkPos();
        ChunkPos regionMaxChunkPos = regionPos.getMaxChunkPos();
        AABB regionAABB = new AABB((double)regionMinChunkPos.getMinBlockX(), -9.9999999E7, (double)regionMinChunkPos.getMinBlockZ(), (double)(regionMaxChunkPos.getMaxBlockX() + 1), 9.9999999E7, (double)(regionMaxChunkPos.getMaxBlockZ() + 1));
        for (Entity entity : level.getEntities(null, regionAABB)) {
            MirthdewEncoreEntityAttachment meea = MirthdewEncoreEntityAttachment.fromEntity(entity);
            EntityDreamtwirlData edd = meea.getDreamtwirlEntityData();
            if (!RegionPos.fromVec3(entity.position()).equals(RegionPos.fromChunkPos(chunkPos))) continue;
            if (edd.canLeave()) {
                edd.leaveDreamtwirl(true);
                continue;
            }
            if (!entity.isInvulnerable() && !(entity instanceof Player)) {
                entity.discard();
                continue;
            }
            entity.hurt(entity.damageSources().outOfBorder(), 1.0E8f);
        }
        PalettedContainer airBlockStateContainer = new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
        Registry biomeRegistry = level.registryAccess().registryOrThrow(Registries.BIOME);
        PalettedContainer biomeContainer = new PalettedContainer(biomeRegistry.asHolderIdMap(), (Object)biomeRegistry.getHolderOrThrow(MirthdewEncoreBiomes.DREAMTWIRL), PalettedContainer.Strategy.SECTION_BIOMES);
        FriendlyByteBuf airBuf = new FriendlyByteBuf(Unpooled.buffer());
        airBuf.writeShort(0);
        airBlockStateContainer.write(airBuf);
        biomeContainer.write(airBuf);
        int sectionsCleared = 0;
        LevelChunkSection[] sections = chunk.getSections();
        for (int s = 0; s < sections.length; ++s) {
            LevelChunkSection section = sections[s];
            if (section.hasOnlyAir()) continue;
            airBuf.resetReaderIndex();
            section.read(airBuf);
            section.recalcBlockCounts();
            ++sectionsCleared;
            SectionPos chunkSectionPos = SectionPos.of((ChunkPos)chunkPos, (int)s);
            ThreadedLevelLightEngine serverLightingProvider = level.getChunkSource().getLightEngine();
            serverLightingProvider.updateSectionStatus(chunkSectionPos, true);
            serverLightingProvider.queueSectionData(LightLayer.BLOCK, chunkSectionPos, null);
            serverLightingProvider.queueSectionData(LightLayer.SKY, chunkSectionPos, null);
        }
        if (sectionsCleared == 0) {
            return true;
        }
        ArrayList<Heightmap.Types> heightmapTypes = new ArrayList<Heightmap.Types>();
        for (Map.Entry entry : chunk.getHeightmaps()) {
            heightmapTypes.add((Heightmap.Types)entry.getKey());
        }
        EnumSet enumSet = EnumSet.copyOf(heightmapTypes);
        Heightmap.primeHeightmaps((ChunkAccess)chunk, enumSet);
        chunk.clearAllBlockEntities();
        List l = level.getChunkSource().chunkMap.getPlayers(chunkPos, false);
        l.forEach(serverPlayerEntity -> {
            PlayerChunkSender chunkDataSender = serverPlayerEntity.connection.chunkSender;
            chunkDataSender.dropChunk(serverPlayerEntity, chunkPos);
            chunkDataSender.markChunkPendingToSend(chunk);
        });
        return true;
    }
}

