/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.generate.place;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.StageDesignData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.graph.RoomGraph;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.Room;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomDoor;
import phanastrae.mirthdew_encore.dreamtwirl.stage.generate.place.PlaceableRoom;

public class PlaceableRoomStorage {
    public static final String KEY_NEXT_ROOM_ID = "next_room_id";
    public static final String KEY_ROOM_LIST = "room_list";
    private final List<PlaceableRoom> rooms = new ObjectArrayList();
    private int nextRoomId = 0;

    public CompoundTag writeNbt(CompoundTag nbt, HolderLookup.Provider registries, StructurePieceSerializationContext spsContext) {
        nbt.putInt(KEY_NEXT_ROOM_ID, this.nextRoomId);
        ListTag list = new ListTag();
        int index = 0;
        for (PlaceableRoom room : this.rooms) {
            CompoundTag roomTag = new CompoundTag();
            room.writeNbt(roomTag, registries, spsContext);
            list.add(index, (Tag)roomTag);
            ++index;
        }
        nbt.put(KEY_ROOM_LIST, (Tag)list);
        return nbt;
    }

    public CompoundTag readNbt(CompoundTag nbt, HolderLookup.Provider registries, StructurePieceSerializationContext spsContext, Level level) {
        if (nbt.contains(KEY_NEXT_ROOM_ID, 3)) {
            this.nextRoomId = nbt.getInt(KEY_NEXT_ROOM_ID);
        }
        this.rooms.clear();
        if (nbt.contains(KEY_ROOM_LIST, 9)) {
            ListTag listTag = nbt.getList(KEY_ROOM_LIST, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag roomTag = listTag.getCompound(i);
                PlaceableRoom room = PlaceableRoom.fromNbt(roomTag, registries, spsContext, level);
                if (room == null) continue;
                this.rooms.add(room);
            }
        }
        return nbt;
    }

    public boolean reset() {
        if (this.rooms.isEmpty() && this.nextRoomId == 0) {
            return false;
        }
        this.rooms.clear();
        this.nextRoomId = 0;
        return true;
    }

    public void addRoom(Room room) {
        this.rooms.add(new PlaceableRoom(room, this.nextRoomId));
        ++this.nextRoomId;
    }

    public void addRooms(List<Room> list) {
        list.forEach(this::addRoom);
    }

    public void addConnections(StageDesignData designData, RoomGraph graph) {
        Object2ObjectOpenHashMap nodeToRoomMap = new Object2ObjectOpenHashMap();
        for (PlaceableRoom room : this.rooms) {
            for (RoomDoor startDoor : room.getRoom().getDoors()) {
                graph.getNode(startDoor).ifPresent(arg_0 -> PlaceableRoomStorage.lambda$addConnections$0((Map)nodeToRoomMap, room, arg_0));
            }
        }
        for (PlaceableRoom room : this.rooms) {
            for (RoomDoor startDoor : room.getRoom().getDoors()) {
                graph.forEachConnectedEndpoint(startDoor.getRoomDoorId(), arg_0 -> PlaceableRoomStorage.lambda$addConnections$1((Map)nodeToRoomMap, designData, room, startDoor, arg_0));
            }
        }
    }

    public void beginEntrancePlacement() {
        for (PlaceableRoom room : this.rooms) {
            if (!room.getRoom().getRoomType().isEntrance()) continue;
            room.beginPlacementFromCenter(true);
        }
    }

    public void startSpawningRoom(int roomId, BlockPos spawnStart, boolean shouldForceLoadChunks) {
        Optional<PlaceableRoom> roomOptional = this.getRoom(roomId);
        if (roomOptional.isEmpty()) {
            return;
        }
        PlaceableRoom room = roomOptional.get();
        room.beginPlacement(spawnStart, shouldForceLoadChunks);
    }

    public List<PlaceableRoom> getRooms() {
        return this.rooms;
    }

    public Optional<PlaceableRoom> getRoom(int id) {
        for (PlaceableRoom room : this.rooms) {
            if (room.getRoomId() != id) continue;
            return Optional.of(room);
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$addConnections$1(Map nodeToRoomMap, StageDesignData designData, PlaceableRoom room, RoomDoor startDoor, RoomDoor.RoomDoorId endNode) {
        if (nodeToRoomMap.containsKey(endNode)) {
            PlaceableRoom targetRoom = (PlaceableRoom)nodeToRoomMap.get(endNode);
            RoomDoor endDoor = designData.getDoor(endNode);
            if (endDoor != null) {
                room.addLychsealDoorEntry(startDoor, endDoor, targetRoom);
            }
        }
    }

    private static /* synthetic */ void lambda$addConnections$0(Map nodeToRoomMap, PlaceableRoom room, RoomDoor.RoomDoorId node) {
        nodeToRoomMap.put(node, room);
    }
}

