/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.generate.place;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import phanastrae.mirthdew_encore.util.FloatNoise2D;

public class RoomActivePlacement {
    public static final FloatNoise2D NOISE = RoomActivePlacement.generateNoise();
    public static final float MAX_NOISE_DELAY = 0.2f;
    public static final float MAX_NOISE_DELAY_TICKS = 4.0f;
    public static final float FOAM_SPEED = 8.5f;
    public static final float TICKS_PER_BLOCK = 2.3529413f;
    public static final float FOAM_DELAY = 0.9f;
    public static final float FOAM_DELAY_TICKS = 18.0f;

    public static float getNoise(int x, int z) {
        return NOISE.get(x, z);
    }

    public static int getTimeToReachPos(BlockPos placementOrigin, BlockPos pos, boolean addDelay, int x, int z) {
        return RoomActivePlacement.getTimeToReachPos(placementOrigin, pos, addDelay, RoomActivePlacement.getNoise(x, z));
    }

    public static int getTimeToReachPos(BlockPos placementOrigin, BlockPos pos, boolean addDelay, float noise) {
        if (placementOrigin == null) {
            return 0;
        }
        BlockPos dif = placementOrigin.subtract((Vec3i)pos);
        int maxDist = dif.getX() * dif.getX() + dif.getY() * dif.getY() + dif.getZ() * dif.getZ();
        return Mth.ceil((double)(Math.sqrt(maxDist) * 2.3529412746429443 + (double)(addDelay ? 18.0f : 0.0f) + (double)noise));
    }

    public static void setBlock(ServerLevel level, BlockPos pos, BlockState state, boolean updateNeighbors) {
        level.setBlock(pos, state, updateNeighbors ? 3 : 2, 512);
    }

    public static void playBlockPlaceEffects(ServerLevel level, RandomSource random, BlockPos pos) {
        if (RoomActivePlacement.blockExposed((LevelReader)level, pos) || random.nextInt(8) == 0) {
            if (random.nextInt(15) == 0) {
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 0.9f, 0.4f + 0.2f * random.nextFloat());
            }
            if (random.nextInt(4) == 0) {
                level.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 14, 0.5, 0.5, 0.5, 0.1);
            }
        }
    }

    public static void playFoamPlaceEffects(ServerLevel level, RandomSource random, BlockPos pos) {
        if (RoomActivePlacement.blockExposed((LevelReader)level, pos) || random.nextInt(8) == 0) {
            if (random.nextInt(15) == 0) {
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 0.5f, 0.4f + 0.2f * random.nextFloat());
            }
            if (random.nextInt(4) == 0) {
                level.sendParticles((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 14, 0.5, 0.5, 0.5, 0.1);
            }
        }
    }

    public static boolean blockExposed(LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos adjPos = pos.mutable();
        for (Direction direction : Direction.values()) {
            adjPos.setWithOffset((Vec3i)pos, direction);
            BlockState adjState = level.getBlockState((BlockPos)adjPos);
            if (adjState.isFaceSturdy((BlockGetter)level, (BlockPos)adjPos, direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static void tryUpdateSelf(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState newState;
        Block block;
        FluidState fluidState = state.getFluidState();
        if (!fluidState.isEmpty()) {
            fluidState.tick((Level)level, pos);
        }
        if (!((block = state.getBlock()) instanceof LiquidBlock) && !(newState = Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)level, (BlockPos)pos)).equals(state)) {
            level.setBlock(pos, newState, 20);
        }
    }

    public static boolean isStateFragile(BlockState state, LevelReader levelReader, BlockPos blockPos) {
        Block block = state.getBlock();
        if (block instanceof EntityBlock) {
            return true;
        }
        if (block instanceof DoorBlock) {
            return true;
        }
        return !state.canSurvive(levelReader, blockPos);
    }

    public static FloatNoise2D generateNoise() {
        RandomSource randomSource = RandomSource.create((long)12345L);
        return FloatNoise2D.generateNoise(128, 128, () -> Float.valueOf(randomSource.nextFloat() * 4.0f));
    }
}

