/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.generate.place;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.block.entity.LychsealBlockEntity;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.Room;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room.RoomLychseal;
import phanastrae.mirthdew_encore.dreamtwirl.stage.design.room_source.RoomSource;

public class RoomPrePlacement {
    public static boolean placeStructure(Room room, ServerLevel serverLevel, WorldGenLevel worldGenLevel, BoundingBox areaBox, boolean forceLoadChunks, int roomId) {
        PiecesContainer piecesContainer = room.getPiecesContainer();
        List list = piecesContainer.pieces();
        BoundingBox blockBox = room.getBoundingBox();
        if (list.isEmpty()) {
            return true;
        }
        ChunkPos chunkPosStart = new ChunkPos(SectionPos.blockToSectionCoord((int)blockBox.minX()), SectionPos.blockToSectionCoord((int)blockBox.minZ()));
        ChunkPos chunkPosEnd = new ChunkPos(SectionPos.blockToSectionCoord((int)blockBox.maxX()), SectionPos.blockToSectionCoord((int)blockBox.maxZ()));
        if (forceLoadChunks) {
            ChunkPos.rangeClosed((ChunkPos)chunkPosStart, (ChunkPos)chunkPosEnd).forEach(p -> serverLevel.getChunk(p.x, p.z));
        }
        if (ChunkPos.rangeClosed((ChunkPos)chunkPosStart, (ChunkPos)chunkPosEnd).anyMatch(p -> !serverLevel.isLoaded(p.getWorldPosition()))) {
            return false;
        }
        BoundingBox firstPieceBB = ((StructurePiece)list.getFirst()).getBoundingBox();
        BlockPos firstPieceCenter = firstPieceBB.getCenter();
        BlockPos firstPieceBasePosition = new BlockPos(firstPieceCenter.getX(), firstPieceBB.minY(), firstPieceCenter.getZ());
        ChunkGenerator chunkGenerator = serverLevel.getChunkSource().getGenerator();
        StructureManager structureAccessor = serverLevel.structureManager();
        RandomSource random = serverLevel.getRandom();
        ChunkPos.rangeClosed((ChunkPos)chunkPosStart, (ChunkPos)chunkPosEnd).forEach(chunkPos -> {
            if (!areaBox.isInside((Vec3i)chunkPos.getBlockAt(0, 0, 0))) {
                return;
            }
            BoundingBox chunkBox = new BoundingBox(chunkPos.getMinBlockX(), serverLevel.getMinBuildHeight(), chunkPos.getMinBlockZ(), chunkPos.getMaxBlockX(), serverLevel.getMaxBuildHeight(), chunkPos.getMaxBlockZ());
            for (StructurePiece structurePiece : list) {
                if (!structurePiece.getBoundingBox().intersects(chunkBox)) continue;
                if (structurePiece instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece poolStructurePiece = (PoolElementStructurePiece)structurePiece;
                    RoomPrePlacement.generate(poolStructurePiece, serverLevel.getStructureManager(), worldGenLevel, structureAccessor, chunkGenerator, random, chunkBox, firstPieceBasePosition);
                    continue;
                }
                structurePiece.postProcess(worldGenLevel, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, firstPieceBasePosition);
            }
        });
        for (StructurePiece structurePiece : list) {
            if (!(structurePiece instanceof PoolElementStructurePiece)) continue;
            PoolElementStructurePiece poolStructurePiece = (PoolElementStructurePiece)structurePiece;
            RoomPrePlacement.placeRoomObjects(poolStructurePiece, serverLevel.getStructureManager(), worldGenLevel, random, room, roomId);
        }
        return true;
    }

    public static void generate(PoolElementStructurePiece structurePiece, StructureTemplateManager structureTemplateManager, WorldGenLevel worldGenLevel, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, BlockPos pivot) {
        StructurePoolElement poolElement = structurePiece.getElement();
        poolElement.place(structureTemplateManager, worldGenLevel, structureAccessor, chunkGenerator, structurePiece.getPosition(), pivot, structurePiece.getRotation(), chunkBox, random, LiquidSettings.IGNORE_WATERLOGGING, false);
    }

    public static void placeRoomObjects(PoolElementStructurePiece structurePiece, StructureTemplateManager structureTemplateManager, WorldGenLevel level, RandomSource random, Room room, int roomId) {
        StructurePoolElement poolElement = structurePiece.getElement();
        BlockPos pos = structurePiece.getPosition();
        Rotation rotation = structurePiece.getRotation();
        RoomPrePlacement.convertDoorMarkers(level, poolElement, structureTemplateManager, pos, rotation, random);
        RoomPrePlacement.convertAcheruneMarkers(level, poolElement, structureTemplateManager, pos, rotation, random);
        RoomPrePlacement.convertLychsealMarkers(level, poolElement, structureTemplateManager, pos, rotation, random, room, roomId);
    }

    public static void convertDoorMarkers(WorldGenLevel level, StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos piecePos, Rotation pieceRotation, RandomSource random) {
        List<StructureTemplate.StructureBlockInfo> doorInfos = RoomSource.getDoorMarkerInfos(poolElement, structureTemplateManager, piecePos, pieceRotation, random);
        for (StructureTemplate.StructureBlockInfo doorInfo : doorInfos) {
            BlockPos pos = doorInfo.pos();
            if (!level.getBlockState(pos).is(MirthdewEncoreBlocks.DOOR_MARKER)) continue;
            CompoundTag nbt = doorInfo.nbt();
            BlockState blockState = Blocks.AIR.defaultBlockState();
            if (nbt != null && nbt.contains("final_state")) {
                String finalState = nbt.getString("final_state");
                try {
                    blockState = BlockStateParser.parseForBlock((HolderLookup)level.holderLookup(Registries.BLOCK), (String)finalState, (boolean)true).blockState();
                }
                catch (CommandSyntaxException var15) {
                    MirthdewEncore.LOGGER.error("Error while parsing blockstate {} in door marker block @ {}", (Object)finalState, (Object)pos);
                }
            }
            level.setBlock(pos, blockState, 3);
        }
    }

    public static void convertAcheruneMarkers(WorldGenLevel level, StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos piecePos, Rotation pieceRotation, RandomSource random) {
        List<StructureTemplate.StructureBlockInfo> greaterAcheruneInfos = RoomSource.getGreaterAcheruneMarkerInfos(poolElement, structureTemplateManager, piecePos, pieceRotation, random);
        for (StructureTemplate.StructureBlockInfo runeInfo : greaterAcheruneInfos) {
            BlockPos pos = runeInfo.pos();
            if (!level.getBlockState(pos).is(MirthdewEncoreBlocks.GREATER_ACHERUNE_MARKER)) continue;
            level.setBlock(pos, MirthdewEncoreBlocks.GREATER_ACHERUNE.defaultBlockState(), 3);
        }
    }

    public static void convertLychsealMarkers(WorldGenLevel level, StructurePoolElement poolElement, StructureTemplateManager structureTemplateManager, BlockPos piecePos, Rotation pieceRotation, RandomSource random, Room room, int roomId) {
        List<StructureTemplate.StructureBlockInfo> lychsealInfos = RoomSource.getLychsealMarkerInfos(poolElement, structureTemplateManager, piecePos, pieceRotation, random);
        for (StructureTemplate.StructureBlockInfo sealInfo : lychsealInfos) {
            BlockPos pos = sealInfo.pos();
            BlockState oldState = sealInfo.state();
            BlockState newState = MirthdewEncoreBlocks.LYCHSEAL.defaultBlockState();
            if (oldState.hasProperty((Property)BlockStateProperties.ORIENTATION)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.ORIENTATION, (Comparable)((FrontAndTop)oldState.getValue((Property)BlockStateProperties.ORIENTATION)));
            }
            if (!level.getBlockState(pos).is(MirthdewEncoreBlocks.LYCHSEAL_MARKER)) continue;
            level.setBlock(pos, newState, 3);
            Optional<RoomLychseal> lychsealOptional = room.getUnplacedLychseal(pos);
            if (lychsealOptional.isPresent()) {
                RoomLychseal lychseal = lychsealOptional.get();
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof LychsealBlockEntity)) continue;
                LychsealBlockEntity lychsealBlockEntity = (LychsealBlockEntity)blockEntity;
                lychsealBlockEntity.setRoomId(roomId);
                lychsealBlockEntity.setLychsealName(lychseal.getLychsealName());
                continue;
            }
            level.destroyBlock(pos, false);
        }
    }
}

