/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.dreamtwirl.stage.play;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import phanastrae.mirthdew_encore.util.RegionPos;

public class DreamtwirlBorder {
    public static final int REGION_SIZE = 512;
    public static final int PADDING_SIZE = 16;
    public final RegionPos regionPos;
    public final int minX;
    public final int minZ;
    public final int maxX;
    public final int maxZ;
    public final VoxelShape voxelShape;

    public DreamtwirlBorder(RegionPos regionPos) {
        this.regionPos = regionPos;
        this.minX = regionPos.worldX + 16;
        this.minZ = regionPos.worldZ + 16;
        this.maxX = regionPos.worldX + 512 - 16;
        this.maxZ = regionPos.worldZ + 512 - 16;
        VoxelShape inside = Shapes.box((double)this.minX, (double)Double.NEGATIVE_INFINITY, (double)this.minZ, (double)this.maxX, (double)Double.POSITIVE_INFINITY, (double)this.maxZ);
        VoxelShape outside = Shapes.box((double)(regionPos.worldX - 16), (double)Double.NEGATIVE_INFINITY, (double)(regionPos.worldZ - 16), (double)(regionPos.worldX + 512 + 16), (double)Double.POSITIVE_INFINITY, (double)(regionPos.worldZ + 512 + 16));
        this.voxelShape = Shapes.join((VoxelShape)outside, (VoxelShape)inside, (BooleanOp)BooleanOp.ONLY_FIRST);
    }

    public boolean entityOutsideBorder(Entity entity) {
        return Shapes.joinIsNotEmpty((VoxelShape)this.voxelShape, (VoxelShape)Shapes.create((AABB)entity.getBoundingBox()), (BooleanOp)BooleanOp.AND);
    }

    public boolean entityTouchingBorder(Entity entity) {
        return Shapes.joinIsNotEmpty((VoxelShape)this.voxelShape, (VoxelShape)Shapes.create((AABB)entity.getBoundingBox().inflate(1.0E-6)), (BooleanOp)BooleanOp.AND);
    }

    public boolean contains(double x, double z, double margin) {
        if (x < (double)this.minX + margin) {
            return false;
        }
        if (x > (double)this.maxX - margin) {
            return false;
        }
        if (z < (double)this.minZ + margin) {
            return false;
        }
        return !(z > (double)this.maxZ - margin);
    }
}

