/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.entity.VericDreamsnareBlockEntity;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreEntityTypeTags;

public class DreamspeckEntity
extends Mob {
    private boolean snared = false;
    @Nullable
    private BlockPos snarePos = null;
    private int decayTimer = 0;

    public DreamspeckEntity(EntityType<? extends Mob> type, Level world) {
        super(type, world);
        this.moveControl = new DreamspeckMoveControl(this);
    }

    public static AttributeSupplier.Builder createDreamspeckAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.15);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FlyRandomlyGoal(this));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("decay_timer", this.decayTimer);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("decay_timer", 3)) {
            this.decayTimer = nbt.getInt("decay_timer");
        }
    }

    public void tick() {
        Level level;
        if (this.random.nextInt(36) == 0 && !this.isSilent()) {
            this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEvents.AMETHYST_BLOCK_RESONATE, this.getSoundSource(), 0.5f + this.random.nextFloat() * 0.2f, 0.3f + this.random.nextFloat() * 1.5f, false);
            this.level().gameEvent((Entity)this, (Holder)GameEvent.STEP, this.position());
        }
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            VericDreamsnareBlockEntity dreamsnareBlockEntity;
            BlockEntity blockEntity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.snared && this.tickCount % 20 == 0 && (!((blockEntity = this.level().getBlockEntity(this.snarePos)) instanceof VericDreamsnareBlockEntity) || (dreamsnareBlockEntity = (VericDreamsnareBlockEntity)blockEntity).getSnaredEntity() != this)) {
                this.setSnare(null);
            }
            if (!this.snared) {
                if (this.decayTimer < Integer.MAX_VALUE) {
                    ++this.decayTimer;
                }
            } else if (this.decayTimer > 0) {
                --this.decayTimer;
            }
            if (this.decayTimer > 4200 && !this.isPersistenceRequired()) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), 80, 0.1, 0.1, 0.1, 0.02);
                this.discard();
                return;
            }
        }
        super.tick();
        this.setNoGravity(true);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !damageSource.isCreativePlayer()) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    public void push(Entity entity) {
        if (entity.getType().is(MirthdewEncoreEntityTypeTags.DREAMSPECK_OPAQUE)) {
            super.push(entity);
        }
    }

    protected void doPush(Entity entity) {
        if (entity.getType().is(MirthdewEncoreEntityTypeTags.DREAMSPECK_OPAQUE)) {
            super.doPush(entity);
        }
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.EMPTY;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.EMPTY;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.EMPTY;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public boolean isSnared() {
        return this.snared;
    }

    public void setSnare(@Nullable BlockPos pos) {
        this.snared = pos != null;
        this.snarePos = pos;
    }

    static class DreamspeckMoveControl
    extends MoveControl {
        private final DreamspeckEntity entity;

        public DreamspeckMoveControl(DreamspeckEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO) {
                Vec3 targetOffset = new Vec3(this.wantedX - this.entity.getX(), this.wantedY - this.entity.getY(), this.wantedZ - this.entity.getZ());
                double targetOffsetLength = targetOffset.length();
                if (targetOffsetLength < this.entity.getBoundingBox().getSize()) {
                    this.operation = MoveControl.Operation.WAIT;
                } else {
                    this.entity.setDeltaMovement(this.entity.getDeltaMovement().add(targetOffset.scale(this.speedModifier * 0.05 / targetOffsetLength)));
                    Vec3 velocity = this.entity.getDeltaMovement();
                    this.entity.setYRot(-((float)Mth.atan2((double)velocity.x, (double)velocity.z)) * 57.295776f);
                    this.entity.yBodyRot = this.entity.getYRot();
                }
            }
        }
    }

    static class FlyRandomlyGoal
    extends Goal {
        private final Mob entity;

        public FlyRandomlyGoal(Mob entity) {
            this.entity = entity;
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            RandomSource random = this.entity.getRandom();
            MoveControl moveControl = this.entity.getMoveControl();
            if (!moveControl.hasWanted() || random.nextInt(FlyRandomlyGoal.reducedTickDelay((int)10)) == 0) {
                moveControl.setWantedPosition(this.entity.getX() + (double)this.getRandomFloat(random, 8.0f), this.entity.getY() + (double)this.getRandomFloat(random, 8.0f) - 1.0, this.entity.getZ() + (double)this.getRandomFloat(random, 8.0f), 1.0);
            }
        }

        public float getRandomFloat(RandomSource random, float distance) {
            return (random.nextFloat() - random.nextFloat()) * distance;
        }
    }
}

