/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import phanastrae.mirthdew_encore.entity.DreamspeckEntity;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityTypes;

public class EntitySleepData {
    private static final long DEEP_SLEEP_TIME = 600L;
    private static final long DREAM_COOLDOWN = 6000L;
    private static final long ATTEMPT_DREAM_COOLDOWN = 100L;
    private static final int DREAM_RECIPROCAL_CHANCE = 8;
    private final LivingEntity entity;
    private long sleepStartTime = -1L;
    private long lastDreamTime = -1L;

    public EntitySleepData(LivingEntity entity) {
        this.entity = entity;
    }

    public void writeNbt(CompoundTag nbt) {
        if (this.sleepStartTime >= 0L) {
            nbt.putLong("SleepStartTime", this.sleepStartTime);
        }
        if (this.lastDreamTime >= 0L) {
            nbt.putLong("LastDreamTime", this.lastDreamTime);
        }
    }

    public void readNbt(CompoundTag nbt) {
        if (nbt.contains("SleepStartTime", 4)) {
            this.sleepStartTime = nbt.getLong("SleepStartTime");
        }
        if (nbt.contains("LastDreamTime", 4)) {
            this.lastDreamTime = nbt.getLong("LastDreamTime");
        }
    }

    public void tick() {
        Level world = this.entity.level();
        if (!world.isClientSide()) {
            boolean sleeping = this.entity.isSleeping();
            if (sleeping) {
                long sleepTime;
                if (this.sleepStartTime < 0L) {
                    this.startSleeping();
                }
                if ((sleepTime = world.getDayTime() - this.sleepStartTime) % 100L == 0L && this.entity.getRandom().nextInt(8) == 0 && this.canEmitDreamspecks()) {
                    this.emitDreamspecks();
                }
            } else if (this.sleepStartTime >= 0L) {
                this.stopSleeping();
            }
        }
    }

    public void startSleeping() {
        this.sleepStartTime = this.entity.level().getDayTime();
    }

    public void stopSleeping() {
        if (this.canEmitDreamspecks()) {
            this.emitDreamspecks();
        }
        this.sleepStartTime = -1L;
    }

    public boolean canEmitDreamspecks() {
        return this.isDeepSleeping() && this.readyToDream();
    }

    public boolean isDeepSleeping() {
        if (this.sleepStartTime < 0L) {
            return false;
        }
        long timeSlept = this.entity.level().getDayTime() - this.sleepStartTime;
        return timeSlept >= 600L;
    }

    public boolean readyToDream() {
        if (this.lastDreamTime < 0L) {
            return true;
        }
        long timeSinceLastDream = this.entity.level().getGameTime() - this.lastDreamTime;
        return timeSinceLastDream >= 6000L;
    }

    public void emitDreamspecks() {
        Level world = this.entity.level();
        this.lastDreamTime = world.getGameTime();
        DreamspeckEntity dreamspeckEntity = (DreamspeckEntity)MirthdewEncoreEntityTypes.DREAMSPECK.create(world);
        if (dreamspeckEntity != null) {
            dreamspeckEntity.setPos(this.entity.getEyePosition());
            dreamspeckEntity.absRotateTo(this.entity.getYRot(), this.entity.getXRot());
            world.addFreshEntity((Entity)dreamspeckEntity);
        }
    }
}

