/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.entity;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.block.AcherunePoweredBlock;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.EntityDreamtwirlData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.StageAcherunes;
import phanastrae.mirthdew_encore.duck.EntityDuckInterface;
import phanastrae.mirthdew_encore.entity.EntitySleepData;
import phanastrae.mirthdew_encore.network.packet.EntityAcheruneWarpingPayload;
import phanastrae.mirthdew_encore.services.XPlatInterface;
import phanastrae.mirthdew_encore.util.BlockPosDimensional;

public class MirthdewEncoreEntityAttachment {
    public static final String KEY_ACHERUNE_WARPING = "acherune_warping";
    public static final String KEY_SLEEPDATA = "SleepData";
    public static final String KEY_TARGET_ACHERUNE = "target_acherune";
    public static final int WARP_TIME = 80;
    private final Entity entity;
    private final EntityDreamtwirlData entityDreamtwirlData;
    @Nullable
    private final EntitySleepData entitySleepData;
    private boolean warping = false;
    @Nullable
    private LinkedAcheruneComponent targetAcherune = null;
    private int warpTicks = 0;

    public MirthdewEncoreEntityAttachment(Entity entity) {
        EntitySleepData entitySleepData;
        this.entity = entity;
        this.entityDreamtwirlData = new EntityDreamtwirlData(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entitySleepData = new EntitySleepData(livingEntity);
        } else {
            entitySleepData = null;
        }
        this.entitySleepData = entitySleepData;
    }

    public void writeNbt(CompoundTag nbt) {
        RegistryOps registryops = this.entity.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (this.entitySleepData != null) {
            CompoundTag sleepData = new CompoundTag();
            this.entitySleepData.writeNbt(sleepData);
            nbt.put(KEY_SLEEPDATA, (Tag)sleepData);
        }
        nbt.putBoolean(KEY_ACHERUNE_WARPING, this.warping);
        if (this.targetAcherune != null) {
            LinkedAcheruneComponent.CODEC.encodeStart((DynamicOps)registryops, (Object)this.targetAcherune).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to encode linked Acherune data for Entity: '{}'", st)).ifPresent(bpdTag -> nbt.put(KEY_TARGET_ACHERUNE, bpdTag));
        }
    }

    public void readNbt(CompoundTag nbt) {
        RegistryOps registryops = this.entity.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (this.entitySleepData != null && nbt.contains(KEY_SLEEPDATA, 10)) {
            CompoundTag sleepData = nbt.getCompound(KEY_SLEEPDATA);
            this.entitySleepData.readNbt(sleepData);
        }
        if (nbt.contains(KEY_ACHERUNE_WARPING, 1)) {
            this.warping = nbt.getBoolean(KEY_ACHERUNE_WARPING);
        }
        if (nbt.contains(KEY_ACHERUNE_WARPING, 10)) {
            LinkedAcheruneComponent.CODEC.parse((DynamicOps)registryops, (Object)nbt.get(KEY_ACHERUNE_WARPING)).resultOrPartial(st -> MirthdewEncore.LOGGER.error("Failed to parse linked Acherune data for Entity: '{}'", st)).ifPresent(this::startWarp);
        } else {
            this.stopWarping();
        }
    }

    public void sendPairingData(ServerPlayer player) {
        if (this.warping) {
            XPlatInterface.INSTANCE.sendPayload(player, new EntityAcheruneWarpingPayload(this.entity.getId(), this.warping));
        }
    }

    public void tick() {
        Level level = this.entity.level();
        boolean clientSide = level.isClientSide;
        RandomSource random = this.entity.getRandom();
        this.entityDreamtwirlData.tick();
        if (this.entitySleepData != null) {
            this.entitySleepData.tick();
        }
        if (this.warping) {
            if (this.keepWarping()) {
                Entity entity;
                if (!clientSide && (entity = this.entity) instanceof Player) {
                    Player player = (Player)entity;
                    player.displayClientMessage((Component)Component.translatable((String)"mirthdew_encore.acherune.exit_warp_info").withStyle(ChatFormatting.AQUA), true);
                }
                ++this.warpTicks;
                this.entity.setDeltaMovement(this.entity.getDeltaMovement().lerp(new Vec3(0.0, 0.025, 0.0), 0.13));
                for (int i = 0; i < 3; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.entity.getX() + (double)this.entity.getBbWidth() * ((double)random.nextFloat() - 0.5), this.entity.getY() + (double)(this.entity.getBbHeight() * random.nextFloat()), this.entity.getZ() + (double)this.entity.getBbWidth() * ((double)random.nextFloat() - 0.5), ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1, ((double)random.nextFloat() - 0.5) * 0.1);
                }
                if (this.warpTicks > 80 && !clientSide) {
                    LinkedAcheruneComponent lac = this.targetAcherune;
                    this.stopWarping();
                    this.warp(lac);
                }
            } else if (!clientSide) {
                this.entity.fallDistance = -5.0f;
                this.stopWarping();
            }
        }
    }

    public void warp(LinkedAcheruneComponent lac) {
        Level level;
        Level level2 = this.entity.level();
        if (!(level2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level2;
        MinecraftServer server = serverLevel.getServer();
        DreamtwirlStage stage = lac.getStage(server);
        if (stage == null) {
            return;
        }
        StageAcherunes stageAcherunes = stage.getStageAcherunes();
        Acherune acherune = lac.getAcherune(server);
        if (acherune == null) {
            return;
        }
        Optional<BlockPos> targetBlockPosOptional = acherune.getTargetPos(server, stageAcherunes);
        if (targetBlockPosOptional.isEmpty()) {
            return;
        }
        BlockPos targetBlockPos = targetBlockPosOptional.get();
        BlockPosDimensional linkedPos = acherune.getLinkedPos();
        if (linkedPos != null && (level = linkedPos.getLevel(server)) instanceof ServerLevel) {
            ServerLevel linkedLevel = (ServerLevel)level;
            this.entity.level().playSound(null, this.entity, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS, 0.4f, 1.0f);
            Vec3 targetPos = targetBlockPos.getBottomCenter();
            this.entity.teleportTo(linkedLevel, targetPos.x, targetPos.y, targetPos.z, Set.of(), this.entity.getYRot(), this.entity.getXRot());
            linkedLevel.playSound(null, this.entity, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS, 0.4f, 1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean keepWarping() {
        if (this.entity.isCrouching()) return false;
        Entity entity = this.entity;
        if (!(entity instanceof Player)) return true;
        Player player = (Player)entity;
        if (player.getAbilities().flying) return false;
        return true;
    }

    public void onJump() {
        BlockPos floorPos;
        BlockState floorState;
        int power;
        Level level = this.entity.level();
        if (!level.isClientSide && !this.warping && (power = AcherunePoweredBlock.getPower(floorState = level.getBlockState(floorPos = this.entity.getBlockPosBelowThatAffectsMyMovement()))) > 0) {
            this.tryStartWarp(floorPos, floorState);
        }
    }

    public void tryStartWarp(BlockPos floorPos, BlockState floorState) {
        Level level = this.entity.level();
        Optional<BlockPos> candidatePosOptional = this.getAcherunePos(level, level.getRandom(), floorPos, 0);
        if (candidatePosOptional.isEmpty()) {
            return;
        }
        BlockPos candidatePos = candidatePosOptional.get();
        DreamtwirlStage stage = DreamtwirlStageManager.getStage(level, candidatePos);
        if (stage == null) {
            return;
        }
        Acherune ac = stage.getStageAcherunes().getAcherune(candidatePos);
        if (ac == null) {
            return;
        }
        LinkedAcheruneComponent lac = LinkedAcheruneComponent.fromAcheruneAndStage(stage, ac);
        this.startWarp(lac);
    }

    public void startWarp(LinkedAcheruneComponent acherune) {
        this.targetAcherune = acherune;
        this.warpTicks = 0;
        this.setWarping(true);
    }

    public void stopWarping() {
        this.targetAcherune = null;
        this.warpTicks = 0;
        this.setWarping(false);
    }

    public Optional<BlockPos> getAcherunePos(Level level, RandomSource random, BlockPos pos, int depth) {
        if (depth > 32) {
            return Optional.empty();
        }
        int power = AcherunePoweredBlock.getPower(level.getBlockState(pos));
        if (power == 32) {
            return Optional.of(pos);
        }
        ObjectArrayList next = new ObjectArrayList();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjPos = pos.relative(direction);
            BlockState adjState = level.getBlockState(adjPos);
            int adjPower = AcherunePoweredBlock.getPower(adjState);
            if (adjPower <= power) continue;
            next.add(adjPos);
        }
        if (next.isEmpty()) {
            return Optional.empty();
        }
        BlockPos nextPos = (BlockPos)next.get(random.nextInt(next.size()));
        return this.getAcherunePos(level, random, nextPos, depth + 1);
    }

    public boolean shouldCancelGravity() {
        return this.warping;
    }

    public float getWarpStartProgress(float partialTicks) {
        int warpTicks = this.getWarpTicks();
        float warpTime = (float)warpTicks + partialTicks;
        return Math.clamp(1.4f * warpTime / 80.0f, 0.0f, 1.0f);
    }

    public float getWarpEndProgress(float partialTicks) {
        int warpTicks = this.getWarpTicks();
        float warpTime = (float)warpTicks + partialTicks;
        return Math.clamp((1.4f * warpTime / 80.0f - 1.0f) * 2.5f, 0.0f, 1.0f);
    }

    public EntityDreamtwirlData getDreamtwirlEntityData() {
        return this.entityDreamtwirlData;
    }

    @Nullable
    public EntitySleepData getEntitySleepData() {
        return this.entitySleepData;
    }

    public void setWarping(boolean warping) {
        boolean wasWarping = this.warping;
        this.warping = warping;
        if (warping != wasWarping) {
            Level level = this.entity.level();
            if (!level.isClientSide) {
                EntityAcheruneWarpingPayload payload = new EntityAcheruneWarpingPayload(this.entity.getId(), warping);
                XPlatInterface.INSTANCE.sendToPlayersTrackingEntity(this.entity, payload);
                Entity entity = this.entity;
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    if (player.connection != null) {
                        XPlatInterface.INSTANCE.sendPayload(player, payload);
                    }
                }
            }
        }
    }

    public boolean isWarping() {
        return this.warping;
    }

    public void setWarpTicks(int warpTicks) {
        this.warpTicks = warpTicks;
    }

    public int getWarpTicks() {
        return this.warpTicks;
    }

    public static MirthdewEncoreEntityAttachment fromEntity(Entity entity) {
        return ((EntityDuckInterface)entity).mirthdew_encore$getAttachment();
    }
}

