/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import phanastrae.mirthdew_encore.duck.FoodDataDuckInterface;
import phanastrae.mirthdew_encore.entity.MirthdewEncorePlayerEntityAttachment;
import phanastrae.mirthdew_encore.entity.effect.MirthdewEncoreStatusEffects;

public class PlayerEntityHungerData {
    private final Player player;
    private boolean isDreamyDieting = false;
    private int preDreamyDietFoodLevel = 20;
    private int dreamyDietTicks = 0;

    public PlayerEntityHungerData(Player player) {
        this.player = player;
    }

    public void tick() {
        if (!this.player.level().isClientSide()) {
            FoodData hungerManager;
            if (this.isDreamyDieting()) {
                int amplifier;
                if (!this.player.hasEffect(MirthdewEncoreStatusEffects.DREAMY_DIET_ENTRY)) {
                    this.onEndDreamyDieting();
                } else {
                    this.player.getFoodData().setFoodLevel(20);
                }
                MobEffectInstance dietEffect = this.player.getEffect(MirthdewEncoreStatusEffects.DREAMY_DIET_ENTRY);
                if (dietEffect != null && !this.player.isSpectator() && !this.player.getAbilities().instabuild && (amplifier = dietEffect.getAmplifier()) >= 0) {
                    this.dreamyDietTicks += amplifier + 1;
                }
            }
            if ((hungerManager = this.player.getFoodData()).getFoodLevel() > 0 && this.getFoodLevelDebt() > 0) {
                hungerManager.setFoodLevel(hungerManager.getFoodLevel() - 1);
                this.setFoodLevelDebt(this.getFoodLevelDebt() - 1);
            }
        }
    }

    public void onStartDreamyDieting() {
        if (!this.isDreamyDieting) {
            this.isDreamyDieting = true;
            FoodData hungerManager = this.player.getFoodData();
            this.preDreamyDietFoodLevel = hungerManager.getFoodLevel() - this.getFoodLevelDebt();
            hungerManager.setFoodLevel(20);
            this.setFoodLevelDebt(0);
        }
    }

    public void onEndDreamyDieting() {
        if (this.isDreamyDieting) {
            this.isDreamyDieting = false;
            FoodData hungerManager = this.player.getFoodData();
            hungerManager.setFoodLevel(Math.clamp((long)this.preDreamyDietFoodLevel, 0, 20));
            this.setFoodLevelDebt(Math.clamp((long)(-this.preDreamyDietFoodLevel), 0, 20));
            this.preDreamyDietFoodLevel = 20;
            this.reduceHungerBasedOnTime(hungerManager, this.dreamyDietTicks);
            this.dreamyDietTicks = 0;
        }
    }

    public void reduceHungerBasedOnTime(FoodData hungerManager, int dietTicks) {
        if (dietTicks < 0) {
            return;
        }
        if (dietTicks > 72000) {
            dietTicks = 72000;
        }
        float exhaustion = hungerManager.getExhaustionLevel();
        float saturationLevel = hungerManager.getSaturationLevel();
        int foodLevel = hungerManager.getFoodLevel();
        int TICKS_PER_EXHAUSTION = 100;
        float gainedExhaustion = (float)dietTicks / (float)TICKS_PER_EXHAUSTION;
        int foodCost = Mth.floor((float)((exhaustion += gainedExhaustion) / 4.0f));
        exhaustion -= (float)(foodCost * 4);
        int maxRemovedSaturation = Mth.ceil((float)saturationLevel);
        int removedSaturation = Math.min(foodCost, maxRemovedSaturation);
        saturationLevel = Math.max(saturationLevel - (float)removedSaturation, 0.0f);
        int removedFoodLevel = Math.min(foodCost -= removedSaturation, foodLevel);
        foodLevel = Math.max(foodLevel - removedFoodLevel, 0);
        hungerManager.setExhaustion(exhaustion);
        hungerManager.setFoodLevel(foodLevel);
        hungerManager.setSaturation(saturationLevel);
        if ((foodCost -= removedFoodLevel) > 0) {
            this.setFoodLevelDebt(Math.min(this.getFoodLevelDebt() + foodCost, 20));
        }
    }

    public void writeNbt(CompoundTag nbtCompound) {
        nbtCompound.putBoolean("IsDreamyDieting", this.isDreamyDieting);
        nbtCompound.putInt("PreDreamyDietFoodLevel", this.preDreamyDietFoodLevel);
        nbtCompound.putInt("DreamyDietTicks", this.dreamyDietTicks);
        nbtCompound.putInt("FoodLevelDebt", this.getFoodLevelDebt());
    }

    public void readNbt(CompoundTag nbtCompound) {
        if (nbtCompound.contains("IsDreamyDieting", 1)) {
            this.isDreamyDieting = nbtCompound.getBoolean("IsDreamyDieting");
        }
        if (nbtCompound.contains("PreDreamyDietFoodLevel", 3)) {
            this.preDreamyDietFoodLevel = nbtCompound.getInt("PreDreamyDietFoodLevel");
        }
        if (nbtCompound.contains("DreamyDietTicks", 3)) {
            this.dreamyDietTicks = nbtCompound.getInt("DreamyDietTicks");
        }
        if (nbtCompound.contains("FoodLevelDebt", 3)) {
            this.setFoodLevelDebt(nbtCompound.getInt("FoodLevelDebt"));
        }
    }

    public boolean isDreamyDieting() {
        return this.isDreamyDieting;
    }

    public int getFoodLevelDebt() {
        return ((FoodDataDuckInterface)this.player.getFoodData()).mirthdew_encore$getFoodLevelDebt();
    }

    public void setFoodLevelDebt(int foodLevelDebt) {
        ((FoodDataDuckInterface)this.player.getFoodData()).mirthdew_encore$setFoodLevelDebt(foodLevelDebt);
    }

    public static PlayerEntityHungerData fromPlayer(Player player) {
        return MirthdewEncorePlayerEntityAttachment.fromPlayer(player).getHungerData();
    }
}

