/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.fluid;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.fluid.VesperbileFluid;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreFluidTags;

public class MirthdewEncoreFluids {
    private static final Map<TagKey<Fluid>, XPlatGenericFluid> XPGF_MAP = new Object2ObjectOpenHashMap();
    private static final Map<TagKey<Fluid>, XPlatGenericFluid> XPGF_ZERO_FALL_DAMAGE_MAP = new Object2ObjectOpenHashMap();
    public static final FlowingFluid VESPERBILE = new VesperbileFluid.Source();
    public static final FlowingFluid FLOWING_VESPERBILE = new VesperbileFluid.Flowing();
    public static final XPlatGenericFluid VESPERBILE_XPGF = new XPlatGenericFluid((Fluid)VESPERBILE, MirthdewEncoreFluidTags.VESPERBILE).setMotionScale(0.036).setDensity(1010).setTemperature(325).setViscosity(3500).setLuminance(9);

    public static void init(BiConsumer<ResourceLocation, Fluid> r) {
        r.accept(MirthdewEncoreFluids.id("vesperbile"), (Fluid)VESPERBILE);
        r.accept(MirthdewEncoreFluids.id("flowing_vesperbile"), (Fluid)FLOWING_VESPERBILE);
        MirthdewEncoreFluids.addXPGFsToMaps(VESPERBILE_XPGF);
    }

    private static ResourceLocation id(String path) {
        return MirthdewEncore.id(path);
    }

    public static void forEachXPGF(Consumer<XPlatGenericFluid> consumer) {
        XPGF_MAP.values().forEach(consumer);
    }

    public static boolean fluidStateIsMirthdewZeroFallDamage(FluidState fluidState) {
        if (fluidState.is(FluidTags.WATER)) {
            return false;
        }
        for (XPlatGenericFluid xpgf : XPGF_ZERO_FALL_DAMAGE_MAP.values()) {
            if (!fluidState.is(xpgf.fluidTag)) continue;
            return true;
        }
        return false;
    }

    private static void addXPGFsToMaps(XPlatGenericFluid ... xpgfs) {
        for (XPlatGenericFluid xpgf : xpgfs) {
            TagKey<Fluid> tag = xpgf.getFluidTag();
            XPGF_MAP.put(tag, xpgf);
            if (xpgf.getFallDistanceModifier() != 0.0f) continue;
            XPGF_ZERO_FALL_DAMAGE_MAP.put(tag, xpgf);
        }
    }

    public static class XPlatGenericFluid {
        private final Fluid fluid;
        private final TagKey<Fluid> fluidTag;
        private double motionScale = 0.014;
        private float fallDistanceModifier = 0.0f;
        private boolean canExtinguish = true;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private int luminance = 0;
        private boolean isWaterEsque = true;

        public XPlatGenericFluid(Fluid fluid, TagKey<Fluid> fluidTag) {
            this.fluid = fluid;
            this.fluidTag = fluidTag;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public TagKey<Fluid> getFluidTag() {
            return this.fluidTag;
        }

        public XPlatGenericFluid setMotionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public double getMotionScale() {
            return this.motionScale;
        }

        public XPlatGenericFluid setFallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        public float getFallDistanceModifier() {
            return this.fallDistanceModifier;
        }

        public XPlatGenericFluid setCanExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        public boolean canExtinguish() {
            return this.canExtinguish;
        }

        public XPlatGenericFluid setDensity(int density) {
            this.density = density;
            return this;
        }

        public int getDensity() {
            return this.density;
        }

        public XPlatGenericFluid setTemperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public int getTemperature() {
            return this.temperature;
        }

        public XPlatGenericFluid setViscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public int getViscosity() {
            return this.viscosity;
        }

        public XPlatGenericFluid setIsWaterEsque(boolean value) {
            this.isWaterEsque = value;
            return this;
        }

        public int getLuminance() {
            return this.luminance;
        }

        public XPlatGenericFluid setLuminance(int luminance) {
            this.luminance = luminance;
            return this;
        }

        public boolean isWaterEsque() {
            return this.isWaterEsque;
        }
    }
}

