/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.fluid;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.fluid.MirthdewEncoreFluids;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;
import phanastrae.mirthdew_encore.particle.MirthdewEncoreParticleTypes;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreFluidTags;

public abstract class VesperbileFluid
extends FlowingFluid {
    public Fluid getFlowing() {
        return MirthdewEncoreFluids.FLOWING_VESPERBILE;
    }

    public Fluid getSource() {
        return MirthdewEncoreFluids.VESPERBILE;
    }

    public Item getBucket() {
        return MirthdewEncoreItems.VESPERBILE_BUCKET;
    }

    protected void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue()) {
            if (random.nextInt(180) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextBoolean() ? random.nextFloat() * 0.2f : random.nextFloat() * 0.4f + 1.5f, false);
            }
        } else if (random.nextInt(50) == 0) {
            level.addParticle((ParticleOptions)MirthdewEncoreParticleTypes.SUNFLECK, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    protected void randomTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
    }

    protected boolean isRandomlyTicking() {
        return false;
    }

    @Nullable
    protected ParticleOptions getDripParticle() {
        return MirthdewEncoreParticleTypes.DRIPPING_VESPERBILE;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockentity);
    }

    public int getSlopeFindDistance(LevelReader level) {
        return 2;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)MirthdewEncoreBlocks.VESPERBILE.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(VesperbileFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == MirthdewEncoreFluids.VESPERBILE || fluid == MirthdewEncoreFluids.FLOWING_VESPERBILE;
    }

    public int getDropOff(LevelReader level) {
        return 1;
    }

    public boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !fluid.is(MirthdewEncoreFluidTags.VESPERBILE);
    }

    public int getTickDelay(LevelReader level) {
        return 4;
    }

    protected boolean canConvertToSource(Level level) {
        return true;
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN) {
            FluidState fluidstate = level.getFluidState(pos);
            if (this.is(MirthdewEncoreFluidTags.VESPERBILE) && fluidstate.is(FluidTags.WATER)) {
                if (blockState.getBlock() instanceof LiquidBlock) {
                    level.setBlock(pos, MirthdewEncoreBlocks.ONYXSCALE.defaultBlockState(), 3);
                }
                this.fizz(level, pos);
                return;
            }
        }
        super.spreadTo(level, pos, blockState, direction, fluidState);
    }

    private void fizz(LevelAccessor level, BlockPos pos) {
        level.levelEvent(1501, pos, 0);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Source
    extends VesperbileFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends VesperbileFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

