/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.LinkedAcheruneComponent;
import phanastrae.mirthdew_encore.component.type.LinkedDreamtwirlComponent;
import phanastrae.mirthdew_encore.component.type.LocationComponent;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;

public class SlumberingEyeItem
extends Item {
    public SlumberingEyeItem(Item.Properties settings) {
        super(settings);
    }

    public boolean isFoil(ItemStack stack) {
        if (SlumberingEyeItem.eyeHasDestination(stack)) {
            return true;
        }
        return super.isFoil(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (SlumberingEyeItem.eyeHasDestination(stack)) {
            return super.use(world, user, hand);
        }
        if (!world.isClientSide()) {
            Vec3 pos = user.isShiftKeyDown() ? user.position() : user.blockPosition().getBottomCenter();
            stack.set(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT, (Object)LocationComponent.fromPosAndLevel(pos, user.level()));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public InteractionResult useOn(UseOnContext context) {
        Acherune acherune;
        BlockPos pos;
        Level level;
        DreamtwirlStage stage;
        ItemStack stack = context.getItemInHand();
        if (!SlumberingEyeItem.eyeHasDestination(stack) && (stage = DreamtwirlStageManager.getStage(level = context.getLevel(), pos = context.getClickedPos())) != null && (acherune = stage.getStageAcherunes().getAcherune(pos)) != null) {
            stack.set(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE, (Object)LinkedAcheruneComponent.fromAcheruneAndStage(stage, acherune));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public static boolean eyeHasDestination(ItemStack itemStack) {
        return itemStack.has(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT) || itemStack.has(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL) || itemStack.has(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            if (other.isEmpty() || !other.is(MirthdewEncoreItems.OCULAR_SOPORSTEW)) {
                return false;
            }
            if (stack.is(MirthdewEncoreItems.SLUMBERING_EYE) && stack.getDamageValue() == 0) {
                return false;
            }
            other.shrink(1);
            this.playEatSound((Entity)player);
            ItemStack newStack = SlumberingEyeItem.repairEye(stack);
            slot.set(newStack);
            return true;
        }
        return false;
    }

    private void playEatSound(Entity entity) {
        entity.playSound(SoundEvents.ENDERMAN_SCREAM, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public static ItemStack damageEye(ItemStack stack) {
        if (stack.is(MirthdewEncoreItems.SLUMBERING_EYE)) {
            ItemStack newStack;
            boolean breaks;
            boolean bl = breaks = stack.getDamageValue() + 1 >= stack.getMaxDamage();
            if (breaks) {
                newStack = MirthdewEncoreItems.SLEEPY_EYE.getDefaultInstance();
                newStack.applyComponentsAndValidate(stack.getComponentsPatch());
                if (newStack.has(DataComponents.DAMAGE)) {
                    newStack.remove(DataComponents.DAMAGE);
                }
                if (newStack.has(DataComponents.MAX_DAMAGE)) {
                    newStack.remove(DataComponents.MAX_DAMAGE);
                }
            } else {
                newStack = stack.copy();
                newStack.setDamageValue(newStack.getDamageValue() + 1);
            }
            return newStack;
        }
        return stack.copy();
    }

    public static ItemStack repairEye(ItemStack stack) {
        if (stack.is(MirthdewEncoreItems.SLEEPY_EYE)) {
            ItemStack newStack = MirthdewEncoreItems.SLUMBERING_EYE.getDefaultInstance();
            newStack.applyComponentsAndValidate(stack.getComponentsPatch());
            newStack.setDamageValue(newStack.getMaxDamage() - 1);
            return newStack;
        }
        if (stack.is(MirthdewEncoreItems.SLUMBERING_EYE)) {
            ItemStack newStack = stack.copy();
            if (newStack.getDamageValue() != 0) {
                newStack.setDamageValue(stack.getDamageValue() - 1);
            }
            return newStack;
        }
        return stack.copy();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        LocationComponent locationComponent = (LocationComponent)stack.get(MirthdewEncoreDataComponentTypes.LOCATION_COMPONENT);
        LinkedDreamtwirlComponent linkedDreamtwirl = (LinkedDreamtwirlComponent)stack.get(MirthdewEncoreDataComponentTypes.LINKED_DREAMTWIRL);
        LinkedAcheruneComponent linkedAcherune = (LinkedAcheruneComponent)stack.get(MirthdewEncoreDataComponentTypes.LINKED_ACHERUNE);
        if (locationComponent != null) {
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound").copy().withStyle(ChatFormatting.LIGHT_PURPLE));
            MutableComponent xyz = Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to.xyz", (Object[])new Object[]{locationComponent.x(), locationComponent.y(), locationComponent.z()}).withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to", (Object[])new Object[]{xyz}).withStyle(ChatFormatting.GRAY));
            MutableComponent dimension = Component.translationArg((ResourceLocation)locationComponent.dimensionId()).copy().withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.in", (Object[])new Object[]{dimension}).withStyle(ChatFormatting.GRAY));
        } else if (linkedDreamtwirl != null) {
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound").copy().withStyle(ChatFormatting.LIGHT_PURPLE));
            MutableComponent stage = Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to.dreamtwirl_stage").withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to", (Object[])new Object[]{stage}).withStyle(ChatFormatting.GRAY));
            MutableComponent dimension = Component.translationArg((ResourceLocation)linkedDreamtwirl.dimensionId()).copy().withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.in", (Object[])new Object[]{dimension}).withStyle(ChatFormatting.GRAY));
        } else if (linkedAcherune != null) {
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound").copy().withStyle(ChatFormatting.LIGHT_PURPLE));
            MutableComponent acherune = Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to.acherune").withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.to", (Object[])new Object[]{acherune}).withStyle(ChatFormatting.GRAY));
            MutableComponent dimension = Component.translationArg((ResourceLocation)linkedAcherune.dimensionId()).copy().withStyle(ChatFormatting.WHITE);
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.bound.in", (Object[])new Object[]{dimension}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.mirthdew_encore.slumbering_eye.unbound").copy().withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

