/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import phanastrae.mirthdew_encore.card_spell.SpellCast;
import phanastrae.mirthdew_encore.card_spell.SpellCastHelper;
import phanastrae.mirthdew_encore.component.MirthdewEncoreDataComponentTypes;
import phanastrae.mirthdew_encore.component.type.SpellChargeComponent;
import phanastrae.mirthdew_encore.component.type.SpellDeckContentsComponent;
import phanastrae.mirthdew_encore.item.MirthdewEncoreItems;

public abstract class SpellCardAbstractItem
extends Item {
    public static final int MAX_CARD_STACK_SIZE = 32;

    public SpellCardAbstractItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 72000;
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        RandomSource random = user.getRandom();
        if (random.nextInt(3) == 0) {
            Player playerEntity;
            SoundEvent soundEvent = random.nextBoolean() ? SoundEvents.BUNDLE_INSERT : SoundEvents.BUNDLE_REMOVE_ONE;
            Player player = user instanceof Player ? (playerEntity = (Player)user) : null;
            world.playSound(player, user.blockPosition(), soundEvent, SoundSource.NEUTRAL, 0.8f, 1.4f + 0.4f * random.nextFloat());
        }
        long worldTime = world.getGameTime();
        SpellChargeComponent spellChargeComponent = (SpellChargeComponent)stack.get(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
        if ((spellChargeComponent == null || !spellChargeComponent.isDisabled(worldTime)) && this.tryToCastNext(world, (Entity)user, stack)) {
            return;
        }
        for (ItemStack stack1 : user.getHandSlots()) {
            if (stack1 == stack || !this.tryToCastNext(world, (Entity)user, stack1)) continue;
            return;
        }
    }

    public boolean tryToCastNext(Level world, Entity user, ItemStack itemStack) {
        long worldTime = world.getGameTime();
        SpellChargeComponent spellChargeComponent = (SpellChargeComponent)itemStack.get(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
        if (spellChargeComponent != null && spellChargeComponent.isDisabled(worldTime)) {
            return false;
        }
        if (!world.isClientSide && world instanceof ServerLevel) {
            SpellChargeComponent.Builder builder;
            ServerLevel serverWorld = (ServerLevel)world;
            if (spellChargeComponent == null) {
                List<SpellCast> spellCastList = SpellCastHelper.castListFromStack(itemStack);
                builder = new SpellChargeComponent.Builder(spellCastList);
            } else {
                builder = new SpellChargeComponent.Builder(spellChargeComponent);
            }
            int totalDelayMs = 0;
            SpellCast nextCast = builder.removeFirst();
            if (nextCast != null) {
                SpellCast.SpellInfoCollector spellInfoCollector = nextCast.castSpell(serverWorld, user);
                totalDelayMs += spellInfoCollector.getCastDelayMs();
                builder.addRechargeDelay(spellInfoCollector.getRechargeDelayMs());
                boolean hadSuccess = spellInfoCollector.getHadSuccess();
                boolean hadFailure = spellInfoCollector.getHadFailure();
                if (hadFailure || !hadSuccess) {
                    Vec3 pos = user.getEyePosition();
                    double spread = hadSuccess ? 0.02 : 0.1;
                    serverWorld.sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y - (hadSuccess ? 0.3 : 0.0), pos.z, hadSuccess ? 20 : 200, spread, spread, spread, hadSuccess ? 0.01 : 0.1);
                    serverWorld.playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 0.6f, hadSuccess ? 1.0f : 0.3f);
                    if (!hadSuccess) {
                        serverWorld.playSound(null, pos.x, pos.y, pos.z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                }
            }
            if (builder.isEmpty()) {
                totalDelayMs += builder.removeRechargeDelay();
                List<SpellCast> spellCastList = SpellCastHelper.castListFromStack(itemStack);
                builder.addAll(spellCastList);
            }
            if (totalDelayMs > 0) {
                int tickDelay = Mth.ceil((float)((float)totalDelayMs / 50.0f));
                builder.setCooldown(worldTime, tickDelay);
            } else {
                builder.setCooldown(0L, 0);
            }
            itemStack.set(MirthdewEncoreDataComponentTypes.SPELL_CHARGE, (Object)builder.build());
        }
        return true;
    }

    public boolean overrideStackedOnOther(ItemStack heldStack, Slot slot, ClickAction clickType, Player player) {
        SpellDeckContentsComponent.Builder builder;
        ItemStack removedStack;
        SpellDeckContentsComponent spellDeckContentsComponent;
        ItemStack baseStack = slot.getItem();
        if (baseStack.isEmpty() && clickType == ClickAction.SECONDARY && (spellDeckContentsComponent = (SpellDeckContentsComponent)heldStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS)) != null && (removedStack = (builder = new SpellDeckContentsComponent.Builder(spellDeckContentsComponent)).removeStackFromBase()) != null) {
            ItemStack screenHandlerCursorStack;
            AbstractContainerMenu screenHandler;
            if (builder.isEmpty()) {
                heldStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, null);
            } else {
                heldStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, (Object)builder.build());
            }
            slot.setByPlayer(removedStack);
            heldStack.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
            if (builder.isEmpty() && (screenHandler = player.containerMenu) != null && (screenHandlerCursorStack = screenHandler.getCarried()) == heldStack) {
                screenHandler.setCarried(SpellCardAbstractItem.getStackWithCorrectItem(heldStack));
            }
            this.playRemoveOneSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack baseStack, ItemStack heldStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (heldStack.isEmpty()) {
            List<ItemStack> stackList;
            SpellDeckContentsComponent spellDeckContentsComponent;
            if (clickType == ClickAction.SECONDARY && (spellDeckContentsComponent = (SpellDeckContentsComponent)baseStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS)) != null && !(stackList = SpellCardAbstractItem.deckStackToStackList(baseStack)).isEmpty()) {
                ItemStack first = stackList.removeFirst();
                first.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
                cursorStackReference.set(first);
                ItemStack remainingDeck = SpellCardAbstractItem.stackListToDeckStack(stackList);
                slot.setByPlayer(remainingDeck);
                this.playRemoveOneSound((Entity)player);
                return true;
            }
        } else if (heldStack.getItem() instanceof SpellCardAbstractItem) {
            if (clickType == ClickAction.PRIMARY) {
                int maxAcceptedCards = SpellCardAbstractItem.getMaxAcceptedCards(baseStack);
                if (maxAcceptedCards < 1) {
                    this.playInsertFailSound((Entity)player);
                    return true;
                }
                heldStack.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
                baseStack.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
                List<ItemStack> heldStackList = SpellCardAbstractItem.deckStackToStackList(heldStack);
                List<ItemStack> baseStackList = SpellCardAbstractItem.deckStackToStackList(baseStack);
                int heldSize = heldStackList.size();
                int removedCards = Math.min(maxAcceptedCards, heldSize);
                List<ItemStack> newHeldStackList = heldStackList.subList(0, heldSize - removedCards);
                ArrayList<ItemStack> newBaseStackList = new ArrayList<ItemStack>(heldStackList.subList(heldSize - removedCards, heldSize));
                newBaseStackList.addAll(baseStackList);
                cursorStackReference.set(SpellCardAbstractItem.stackListToDeckStack(newHeldStackList));
                slot.setByPlayer(SpellCardAbstractItem.stackListToDeckStack(newBaseStackList));
                this.playRemoveOneSound((Entity)player);
                this.playInsertSound((Entity)player);
                return true;
            }
            if (clickType == ClickAction.SECONDARY) {
                ItemStack removedStack;
                if (SpellCardAbstractItem.getMaxAcceptedCards(baseStack) < 1) {
                    this.playInsertFailSound((Entity)player);
                    return true;
                }
                heldStack.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
                baseStack.remove(MirthdewEncoreDataComponentTypes.SPELL_CHARGE);
                SpellDeckContentsComponent spellDeckContentsComponent = (SpellDeckContentsComponent)heldStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
                if (spellDeckContentsComponent == null || spellDeckContentsComponent.isEmpty()) {
                    removedStack = SpellCardAbstractItem.getStackWithCorrectItem(heldStack);
                    cursorStackReference.set(ItemStack.EMPTY.copy());
                } else {
                    SpellDeckContentsComponent.Builder builder = new SpellDeckContentsComponent.Builder(spellDeckContentsComponent);
                    removedStack = builder.removeStackFromBase();
                    heldStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, (Object)builder.build());
                    cursorStackReference.set(SpellCardAbstractItem.getStackWithCorrectItem(heldStack));
                }
                if (removedStack != null) {
                    removedStack = removedStack.copy();
                    slot.setByPlayer(SpellCardAbstractItem.getMerged(removedStack, baseStack));
                }
                this.playRemoveOneSound((Entity)player);
                this.playInsertSound((Entity)player);
                return true;
            }
        }
        return false;
    }

    public static List<ItemStack> deckStackToStackList(ItemStack deckStack) {
        SpellDeckContentsComponent deckContents = (SpellDeckContentsComponent)deckStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (deckContents == null) {
            stackList.add(deckStack.copy());
        } else {
            ItemStack topStack = deckStack.copy();
            topStack.remove(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
            stackList.add(SpellCardAbstractItem.getStackWithCorrectItem(topStack));
            for (ItemStack stack : deckContents.iterate()) {
                stackList.add(stack.copy());
            }
        }
        return stackList;
    }

    public static ItemStack stackListToDeckStack(List<ItemStack> stackList) {
        if (stackList == null || stackList.isEmpty()) {
            return ItemStack.EMPTY.copy();
        }
        if (stackList.size() == 1) {
            return stackList.getFirst();
        }
        ItemStack topStack = stackList.getFirst().copy();
        SpellDeckContentsComponent deckContents = (SpellDeckContentsComponent)topStack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
        SpellDeckContentsComponent.Builder builder = deckContents == null ? new SpellDeckContentsComponent.Builder() : new SpellDeckContentsComponent.Builder(deckContents);
        for (int i = 1; i < stackList.size(); ++i) {
            builder.addStackToBase(stackList.get(i));
        }
        topStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, (Object)builder.build());
        return SpellCardAbstractItem.getStackWithCorrectItem(topStack);
    }

    public static int getMaxAcceptedCards(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (stack.getItem() instanceof SpellCardAbstractItem) {
            SpellDeckContentsComponent deckContents = (SpellDeckContentsComponent)stack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
            if (deckContents == null) {
                return 31;
            }
            int accepted = 31 - deckContents.size();
            if (accepted < 0) {
                accepted = 0;
            }
            return accepted;
        }
        return 0;
    }

    public static ItemStack getMerged(ItemStack top, ItemStack bottom) {
        SpellDeckContentsComponent spellDeckContentsComponent = (SpellDeckContentsComponent)top.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
        SpellDeckContentsComponent.Builder builder = spellDeckContentsComponent == null ? new SpellDeckContentsComponent.Builder() : new SpellDeckContentsComponent.Builder(spellDeckContentsComponent);
        SpellDeckContentsComponent baseStackSpellDeckContentsComponent = (SpellDeckContentsComponent)bottom.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
        if (baseStackSpellDeckContentsComponent == null) {
            builder.addStackToBase(bottom.copy());
        } else {
            ItemStack newBottom = bottom.copy();
            newBottom.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, null);
            builder.addStackToBase(SpellCardAbstractItem.getStackWithCorrectItem(newBottom));
            for (ItemStack itemStack : baseStackSpellDeckContentsComponent.iterate()) {
                builder.addStackToBase(itemStack.copy());
            }
        }
        ItemStack newTop = top.copy();
        newTop.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, (Object)builder.build());
        return SpellCardAbstractItem.getStackWithCorrectItem(newTop);
    }

    public static ItemStack getStackWithCorrectItem(ItemStack stack) {
        SpellDeckContentsComponent spellDeckContentsComponent = (SpellDeckContentsComponent)stack.get(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS);
        if (stack.is(MirthdewEncoreItems.SPELL_CARD)) {
            if (spellDeckContentsComponent != null) {
                if (spellDeckContentsComponent.isEmpty()) {
                    ItemStack newStack = stack.copy();
                    newStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, null);
                    return newStack;
                }
                ItemStack newStack = MirthdewEncoreItems.SPELL_DECK.getDefaultInstance();
                newStack.applyComponentsAndValidate(stack.getComponentsPatch());
                return newStack;
            }
        } else if (stack.is(MirthdewEncoreItems.SPELL_DECK)) {
            if (spellDeckContentsComponent == null || spellDeckContentsComponent.isEmpty()) {
                ItemStack newStack = MirthdewEncoreItems.SPELL_CARD.getDefaultInstance();
                newStack.applyComponentsAndValidate(stack.getComponentsPatch());
                if (spellDeckContentsComponent != null) {
                    newStack.set(MirthdewEncoreDataComponentTypes.SPELL_DECK_CONTENTS, null);
                }
                return newStack;
            }
            return stack.copy();
        }
        return stack.copy();
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 1.0f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 1.0f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertFailSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.3f + entity.level().getRandom().nextFloat() * 0.3f);
    }
}

