/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.mixin;

import com.google.common.collect.ImmutableList;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import phanastrae.mirthdew_encore.compat.Compat;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.duck.EntityDuckInterface;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityAttachment;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreEntityTypeTags;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreFluidTags;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements EntityDuckInterface {
    @Shadow
    protected boolean firstTick;
    @Unique
    private boolean mirthdew_encore$wasTouchingVesperbile = false;
    @Unique
    private MirthdewEncoreEntityAttachment mirthdew_encore$entityAttachment;

    @Shadow
    private static List<VoxelShape> collectColliders(@Nullable Entity entity, Level world, List<VoxelShape> regularCollisions, AABB movingEntityBoundingBox) {
        return List.of();
    }

    @Shadow
    private static Vec3 collideWithShapes(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions) {
        return Vec3.ZERO;
    }

    @Shadow
    public abstract double getFluidHeight(TagKey<Fluid> var1);

    @Shadow
    protected abstract void doWaterSplashEffect();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void mirthdew_encore$init(EntityType type, Level world, CallbackInfo ci) {
        this.mirthdew_encore$entityAttachment = new MirthdewEncoreEntityAttachment((Entity)this);
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private void mirthdew_encore$writeNbt(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        if (nbt.contains("MirthdewEncore", 10)) {
            CompoundTag nbtCompound = nbt.getCompound("MirthdewEncore");
            this.mirthdew_encore$entityAttachment.writeNbt(nbtCompound);
        } else {
            CompoundTag nbtCompound = new CompoundTag();
            this.mirthdew_encore$entityAttachment.writeNbt(nbtCompound);
            nbt.put("MirthdewEncore", (Tag)nbtCompound);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void mirthdew_encore$readNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("MirthdewEncore", 10)) {
            CompoundTag nbtCompound = nbt.getCompound("MirthdewEncore");
            this.mirthdew_encore$entityAttachment.readNbt(nbtCompound);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="RETURN")})
    private void mirthdew_encore$tick(CallbackInfo ci) {
        this.mirthdew_encore$entityAttachment.tick();
    }

    @ModifyVariable(method={"collide"}, at=@At(value="STORE"), ordinal=1)
    private Vec3 mirthdew_encore$collide(Vec3 value, @Local(ordinal=0) Vec3 movement, @Local(ordinal=0) List<VoxelShape> voxelShapeList) {
        Entity thisEntity = (Entity)this;
        AABB box = thisEntity.getBoundingBox();
        if (movement.lengthSqr() != 0.0) {
            if (Compat.USE_DREAMSPECK_COLLISION_COMPAT && thisEntity.getType().is(MirthdewEncoreEntityTypeTags.USES_DREAMSPECK_COLLISION)) {
                List<VoxelShape> list = EntityMixin.collectColliders(thisEntity, thisEntity.level(), voxelShapeList, box.expandTowards(movement));
                value = EntityMixin.collideWithShapes(movement, box, list);
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            DreamtwirlLevelAttachment.findBorderCollision(thisEntity, thisEntity.level(), (ImmutableList.Builder<VoxelShape>)builder);
            ImmutableList list = builder.build();
            if (!list.isEmpty()) {
                value = EntityMixin.collideWithShapes(value, box, (List<VoxelShape>)list);
            }
        }
        return value;
    }

    @Inject(method={"getGravity"}, at={@At(value="HEAD")}, cancellable=true)
    private void mirthdew_encore$cancelGravity(CallbackInfoReturnable<Double> cir) {
        if (this.mirthdew_encore$entityAttachment.shouldCancelGravity()) {
            cir.setReturnValue((Object)0.0);
        }
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="RETURN")})
    private void mirthdew_encore$playFluidsSplashEffect(TagKey<Fluid> fluidTag, double motionScale, CallbackInfoReturnable<Boolean> cir) {
        if (fluidTag.equals(MirthdewEncoreFluidTags.VESPERBILE)) {
            boolean touchingVesperbile;
            boolean bl = touchingVesperbile = this.getFluidHeight(MirthdewEncoreFluidTags.VESPERBILE) > 0.0;
            if (touchingVesperbile != this.mirthdew_encore$wasTouchingVesperbile && !this.firstTick) {
                this.doWaterSplashEffect();
            }
            this.mirthdew_encore$wasTouchingVesperbile = touchingVesperbile;
        }
    }

    @Override
    public MirthdewEncoreEntityAttachment mirthdew_encore$getAttachment() {
        return this.mirthdew_encore$entityAttachment;
    }
}

