/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import phanastrae.mirthdew_encore.duck.PlayerDuckInterface;
import phanastrae.mirthdew_encore.entity.MirthdewEncorePlayerEntityAttachment;
import phanastrae.mirthdew_encore.entity.effect.MirthdewEncoreStatusEffects;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerDuckInterface {
    @Unique
    private MirthdewEncorePlayerEntityAttachment mirthdew_encore$playerEntityAttachment;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void mirthdew_encore$init(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        this.mirthdew_encore$playerEntityAttachment = new MirthdewEncorePlayerEntityAttachment((Player)this);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void mirthdew_encore$tick(CallbackInfo ci) {
        this.mirthdew_encore$playerEntityAttachment.tick();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void mirthdew_encore$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("MirthdewEncore", 10)) {
            CompoundTag nbtCompound = nbt.getCompound("MirthdewEncore");
            this.mirthdew_encore$playerEntityAttachment.writeNbt(nbtCompound);
        } else {
            CompoundTag nbtCompound = new CompoundTag();
            this.mirthdew_encore$playerEntityAttachment.writeNbt(nbtCompound);
            nbt.put("MirthdewEncore", (Tag)nbtCompound);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void mirthdew_encore$readNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("MirthdewEncore", 10)) {
            CompoundTag nbtCompound = nbt.getCompound("MirthdewEncore");
            this.mirthdew_encore$playerEntityAttachment.readNbt(nbtCompound);
        }
    }

    @Inject(method={"canEat"}, at={@At(value="HEAD")}, cancellable=true)
    private void mirthdew_encore$canAlwaysConsumeIfDreamyDieting(boolean ignoreHunger, CallbackInfoReturnable<Boolean> cir) {
        if (this.hasEffect(MirthdewEncoreStatusEffects.DREAMY_DIET_ENTRY)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public MirthdewEncorePlayerEntityAttachment mirthdew_encore$getAttachment() {
        return this.mirthdew_encore$playerEntityAttachment;
    }
}

