/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.util.BiConsumer;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlLevelAttachment;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityTypes;
import phanastrae.mirthdew_encore.entity.effect.MirthdewEncoreStatusEffects;
import phanastrae.mirthdew_encore.item.MirthdewEncoreCreativeModeTabs;
import phanastrae.mirthdew_encore.neoforge.fluid.MirthdewEncoreFluidTypes;
import phanastrae.mirthdew_encore.network.MirthdewEncorePayloads;
import phanastrae.mirthdew_encore.registry.MirthdewEncoreRegistries;
import phanastrae.mirthdew_encore.server.command.MirthdewEncoreCommands;

@Mod(value="mirthdew_encore")
public class MirthdewEncoreNeoForge {
    public MirthdewEncoreNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        this.setupModBusEvents(modEventBus);
        this.setupGameBusEvents(NeoForge.EVENT_BUS);
    }

    public void setupModBusEvents(final IEventBus modEventBus) {
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(this::registerDatapackRegistries);
        DeferredRegister mobEffectDeferredRegister = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"mirthdew_encore");
        mobEffectDeferredRegister.register(modEventBus);
        MirthdewEncoreStatusEffects.init((name, mobEffect) -> mobEffectDeferredRegister.register(name, () -> mobEffect));
        MirthdewEncore.RegistryListenerAdder RLA = new MirthdewEncore.RegistryListenerAdder(){

            @Override
            public <T> void addRegistryListener(Registry<T> registry, Consumer<java.util.function.BiConsumer<ResourceLocation, T>> source) {
                modEventBus.addListener(event -> {
                    ResourceKey registryKey = registry.key();
                    if (registryKey.equals(event.getRegistryKey())) {
                        source.accept((resourceLocation, t) -> event.register(registryKey, resourceLocation, () -> t));
                    }
                });
            }
        };
        MirthdewEncore.registriesInit(RLA);
        this.neoforgeRegistriesInit(RLA);
        modEventBus.addListener(this::commonInit);
        modEventBus.addListener(this::entityAttributeCreation);
        modEventBus.addListener(this::buildCreativeModeTabContents);
        modEventBus.addListener(this::registerPayloadHandlers);
    }

    public void setupGameBusEvents(IEventBus gameEventBus) {
        gameEventBus.addListener(this::registerCommands);
        gameEventBus.addListener(this::tickLevel);
        gameEventBus.addListener(this::addTooltips);
    }

    public void registerRegistries(NewRegistryEvent event) {
        MirthdewEncoreRegistries.registerRegistries(arg_0 -> ((NewRegistryEvent)event).register(arg_0));
    }

    public void registerDatapackRegistries(final DataPackRegistryEvent.NewRegistry event) {
        MirthdewEncoreRegistries.registerSynced(new MirthdewEncoreRegistries.SyncedHelper(){

            @Override
            public <T> void register(ResourceKey<Registry<T>> registryKey, Codec<T> codec) {
                event.dataPackRegistry(registryKey, codec, codec);
            }
        });
    }

    public void neoforgeRegistriesInit(MirthdewEncore.RegistryListenerAdder registryListenerAdder) {
        registryListenerAdder.addRegistryListener(NeoForgeRegistries.FLUID_TYPES, MirthdewEncoreFluidTypes::init);
    }

    public void commonInit(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MirthdewEncore.commonInit();
            MirthdewEncoreFluidTypes.registerFluidInteractions();
        });
    }

    public void entityAttributeCreation(EntityAttributeCreationEvent event) {
        MirthdewEncoreEntityTypes.registerEntityAttributes((BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>)((BiConsumer)(entityType, builder) -> event.put(entityType, builder.build())));
    }

    public void buildCreativeModeTabContents(final BuildCreativeModeTabContentsEvent event) {
        final ResourceKey eventKey = event.getTabKey();
        MirthdewEncoreCreativeModeTabs.setupEntires(new MirthdewEncoreCreativeModeTabs.Helper(this){

            @Override
            public void add(ResourceKey<CreativeModeTab> tabKey, ItemLike item) {
                if (eventKey.equals(tabKey)) {
                    event.accept(item);
                }
            }

            @Override
            public void add(ResourceKey<CreativeModeTab> tabKey, ItemLike ... items) {
                if (eventKey.equals(tabKey)) {
                    for (ItemLike item : items) {
                        event.accept(item);
                    }
                }
            }

            @Override
            public void add(ResourceKey<CreativeModeTab> tabKey, ItemStack item) {
                if (eventKey.equals(tabKey)) {
                    event.accept(item);
                }
            }

            @Override
            public void add(ResourceKey<CreativeModeTab> tabKey, Collection<ItemStack> items) {
                if (eventKey.equals(tabKey)) {
                    for (ItemStack item : items) {
                        event.accept(item);
                    }
                }
            }

            @Override
            public void addAfter(ItemLike after, ResourceKey<CreativeModeTab> tabKey, ItemLike item) {
                if (eventKey.equals(tabKey)) {
                    event.insertAfter(new ItemStack(after), new ItemStack(item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }

            @Override
            public void addAfter(ItemStack after, ResourceKey<CreativeModeTab> tabKey, ItemStack item) {
                if (eventKey.equals(tabKey)) {
                    event.insertAfter(after, item, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }

            @Override
            public void addAfter(ItemLike after, ResourceKey<CreativeModeTab> tabKey, ItemLike ... items) {
                if (eventKey.equals(tabKey)) {
                    for (ItemLike item : items) {
                        event.insertAfter(new ItemStack(after), new ItemStack(item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        after = item;
                    }
                }
            }

            @Override
            public void forTabRun(ResourceKey<CreativeModeTab> tabKey, java.util.function.BiConsumer<CreativeModeTab.ItemDisplayParameters, CreativeModeTab.Output> biConsumer) {
                if (eventKey.equals(tabKey)) {
                    biConsumer.accept(event.getParameters(), (CreativeModeTab.Output)event);
                }
            }

            @Override
            public boolean operatorTabEnabled() {
                return event.getParameters().hasPermissions();
            }
        });
    }

    public void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        final PayloadRegistrar registrar = event.registrar("1");
        MirthdewEncorePayloads.init(new MirthdewEncorePayloads.Helper(){

            @Override
            public <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, java.util.function.BiConsumer<T, Player> clientCallback) {
                registrar.playToClient(id, codec, (payload, context) -> clientCallback.accept(payload, context.player()));
            }

            @Override
            public <T extends CustomPacketPayload> void registerC2S(CustomPacketPayload.Type<T> id, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, java.util.function.BiConsumer<T, Player> serverCallback) {
                registrar.playToServer(id, codec, (payload, context) -> serverCallback.accept(payload, context.player()));
            }
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        MirthdewEncoreCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    public void tickLevel(LevelTickEvent.Pre event) {
        DreamtwirlLevelAttachment.tickLevel(event.getLevel());
    }

    public void addTooltips(ItemTooltipEvent event) {
        MirthdewEncore.addTooltips(event.getItemStack(), event.getContext(), event.getToolTip()::add, event.getFlags());
    }
}

