/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.server.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import phanastrae.mirthdew_encore.card_spell.PlayerEntityMirthData;
import phanastrae.mirthdew_encore.dreamtwirl.DreamtwirlStageManager;
import phanastrae.mirthdew_encore.dreamtwirl.EntityDreamtwirlData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.BasicStageData;
import phanastrae.mirthdew_encore.dreamtwirl.stage.DreamtwirlStage;
import phanastrae.mirthdew_encore.dreamtwirl.stage.acherune.Acherune;
import phanastrae.mirthdew_encore.dreamtwirl.stage.generate.place.PlaceableRoom;
import phanastrae.mirthdew_encore.entity.MirthdewEncoreEntityAttachment;
import phanastrae.mirthdew_encore.entity.MirthdewEncorePlayerEntityAttachment;
import phanastrae.mirthdew_encore.util.BlockPosDimensional;
import phanastrae.mirthdew_encore.util.RegionPos;

public class MirthdewCommand {
    private static final SimpleCommandExceptionType FAILED_NO_MANAGER_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.failed.no_manager", (Object[])new Object[0]));
    private static final DynamicCommandExceptionType FAILED_JOIN_TARGET_NOT_IN_DREAMTWIRL_EXCEPTION = new DynamicCommandExceptionType(playerName -> Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.join.failed.target_not_in_dreamtwirl", (Object[])new Object[]{playerName}));
    private static final SimpleCommandExceptionType FAILED_DOES_NOT_EXIST_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.failed.does_not_exist", (Object[])new Object[0]));
    private static final DynamicCommandExceptionType FAILED_JOIN_SINGLE_EXCEPTION = new DynamicCommandExceptionType(playerName -> Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.join.failed.single", (Object[])new Object[]{playerName}));
    private static final DynamicCommandExceptionType FAILED_JOIN_MULTIPLE_EXCEPTION = new DynamicCommandExceptionType(playerCount -> Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.join.failed.multiple", (Object[])new Object[]{playerCount}));
    private static final SimpleCommandExceptionType FAILED_CREATE_ALREADY_EXISTS_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.create.failed.already_exists", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_CREATE_NO_CANDIDATE_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.create.failed.no_candidate", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_CREATE_INVALID_POSITION_EXCEPTION = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.create.failed.invalid_position", (Object[])new Object[0]));
    private static final DynamicCommandExceptionType FAILED_LEAVE_SINGLE_EXCEPTION = new DynamicCommandExceptionType(playerName -> Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.leave.failed.single", (Object[])new Object[]{playerName}));
    private static final DynamicCommandExceptionType FAILED_LEAVE_MULTIPLE_EXCEPTION = new DynamicCommandExceptionType(playerCount -> Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.leave.failed.multiple", (Object[])new Object[]{playerCount}));
    private static final SimpleCommandExceptionType FAILED_SDG_ALREADY_CLEAR = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.sdg.failed.already_cleared", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_ROOM_STORAGE_ALREADY_CLEAR = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.rooms.failed.already_cleared", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_ACHERUNES_ALREADY_CLEAR = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.acherunes.failed.already_cleared", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_DREAMTWIRL_ALREADY_CLEARING = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.everything.failed.already_clearing", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_STAGE_DELETING = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.failed.stage_deleting", (Object[])new Object[0]));
    private static final SimpleCommandExceptionType FAILED_INVALID_BOUNDS = new SimpleCommandExceptionType((Message)Component.translatableEscape((String)"commands.mirthdew_encore.dreamtwirl.valid_regions.failed.invalid_bounds", (Object[])new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mirthdew").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dreamtwirl").then(((LiteralArgumentBuilder)Commands.literal((String)"join").then(Commands.literal((String)"region").then(Commands.argument((String)"regionX", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"regionZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MirthdewCommand.join((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)context.getSource()).getEntityOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> MirthdewCommand.join((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"), EntityArgument.getEntities((CommandContext)context, (String)"targets")))))))).then(Commands.literal((String)"player").then(((RequiredArgumentBuilder)Commands.argument((String)"targetPlayer", (ArgumentType)EntityArgument.player()).executes(context -> MirthdewCommand.joinPlayer((CommandSourceStack)context.getSource(), (Entity)EntityArgument.getPlayer((CommandContext)context, (String)"targetPlayer"), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)context.getSource()).getEntityOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> MirthdewCommand.joinPlayer((CommandSourceStack)context.getSource(), (Entity)EntityArgument.getPlayer((CommandContext)context, (String)"targetPlayer"), EntityArgument.getEntities((CommandContext)context, (String)"targets")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"leave").executes(context -> MirthdewCommand.leave((CommandSourceStack)context.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)context.getSource()).getEntityOrException())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> MirthdewCommand.leave((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"create").executes(context -> MirthdewCommand.create((CommandSourceStack)context.getSource()))).then(Commands.argument((String)"regionX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"regionZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MirthdewCommand.create((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"))))))).then(Commands.literal((String)"list").executes(context -> MirthdewCommand.list((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"edit").then(Commands.argument((String)"regionX", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"regionZ", (ArgumentType)IntegerArgumentType.integer()).then(Commands.literal((String)"generate").executes(context -> MirthdewCommand.generate((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").then(((LiteralArgumentBuilder)Commands.literal((String)"theEntireDreamtwirlIncludingTheBlocksYesAllOfItPleaseJustDeleteItAll").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"CONFIRM").executes(context -> MirthdewCommand.clearTheEntireDreamtwirlIncludingTheBlocksYesAllOfItPleaseJustDeleteItAll((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ")))))).then(Commands.literal((String)"stageDesignGenerator").executes(context -> MirthdewCommand.clearSDG((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"))))).then(Commands.literal((String)"roomStorage").executes(context -> MirthdewCommand.clearRoomStorage((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ"))))).then(Commands.literal((String)"acherunes").executes(context -> MirthdewCommand.clearAcherunes((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ")))))).then(Commands.literal((String)"placeAllRooms").executes(context -> MirthdewCommand.placeAllRooms((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ")))))))).then(Commands.literal((String)"info").then(Commands.argument((String)"regionX", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.argument((String)"regionZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MirthdewCommand.info((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ")))).then(Commands.literal((String)"acherunes").executes(context -> MirthdewCommand.acheruneInfo((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"regionZ")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"validRegions").then(Commands.literal((String)"query").executes(context -> MirthdewCommand.queryValidRegions((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"minRegionX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"minRegionZ", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"maxRegionX", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"maxRegionZ", (ArgumentType)IntegerArgumentType.integer()).executes(context -> MirthdewCommand.setValidRegions((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"minRegionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"minRegionZ"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxRegionX"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxRegionZ")))))))).then(Commands.literal((String)"default").executes(context -> MirthdewCommand.setValidRegionsDefault((CommandSourceStack)context.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mirth").then(Commands.literal((String)"add").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> MirthdewCommand.addMirth((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), LongArgumentType.getLong((CommandContext)context, (String)"amount"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> MirthdewCommand.removeMirth((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), LongArgumentType.getLong((CommandContext)context, (String)"amount"))))))).then(Commands.literal((String)"set").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> MirthdewCommand.setMirth((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), LongArgumentType.getLong((CommandContext)context, (String)"value"))))))).then(Commands.literal((String)"query").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> MirthdewCommand.queryMirth((CommandSourceStack)context.getSource(), (Player)EntityArgument.getPlayer((CommandContext)context, (String)"target")))))));
    }

    private static int create(CommandSourceStack source) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        Optional<DreamtwirlStage> stageOptional = dreamtwirlStageManager.createNewStage();
        if (stageOptional.isPresent()) {
            RegionPos regionPos = stageOptional.get().getRegionPos();
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.create.success", (Object[])new Object[]{regionPos.regionX, regionPos.regionZ}), true);
            return 1;
        }
        throw FAILED_CREATE_NO_CANDIDATE_EXCEPTION.create();
    }

    private static int create(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        RegionPos dreamtwirlRegionPos;
        if ((regionX & 1) != 0 || (regionZ & 1) != 0) {
            throw FAILED_CREATE_INVALID_POSITION_EXCEPTION.create();
        }
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = dreamtwirlStageManager.getDreamtwirlIfPresent(dreamtwirlRegionPos = new RegionPos(regionX, regionZ));
        if (dreamtwirlStage != null) {
            throw FAILED_CREATE_ALREADY_EXISTS_EXCEPTION.create();
        }
        dreamtwirlStageManager.getOrCreateDreamtwirlStage(dreamtwirlRegionPos);
        source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.create.success", (Object[])new Object[]{regionX, regionZ}), true);
        return 1;
    }

    private static int list(CommandSourceStack source) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        int count = dreamtwirlStageManager.getDreamtwirlStageCount();
        if (count > 0) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.list.count", (Object[])new Object[]{count}), false);
            long levelTime = source.getLevel().getGameTime();
            for (BasicStageData BSD : dreamtwirlStageManager.getBasicStageDatas().values().stream().sorted(Comparator.comparingLong(BasicStageData::getTimestamp)).toList()) {
                RegionPos regionPos = BSD.getRegionPos();
                Component dreamtwirlComponent = MirthdewCommand.getDreamtwirlComponent(BSD.isDeletingSelf());
                Component regionXComponent = MirthdewCommand.getRegionXComponent(regionPos.regionX);
                Component regionZComponent = MirthdewCommand.getRegionZComponent(regionPos.regionZ);
                MutableComponent ageComponent = BSD.getAgeTextComponentFromLevelTime(levelTime).copy().withStyle(ChatFormatting.YELLOW);
                source.sendSuccess(() -> MirthdewCommand.lambda$list$34(dreamtwirlComponent, regionXComponent, regionZComponent, (Component)ageComponent), false);
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.list.none_exist"), false);
        }
        return count;
    }

    private static int generate(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        long dreamtwirlSeed = source.getLevel().getRandom().nextLong();
        dreamtwirlStage.generate(dreamtwirlSeed, source.getLevel());
        source.sendSuccess(() -> Component.literal((String)"Begun Dreamtwirl Generation"), true);
        return 1;
    }

    private static int clearTheEntireDreamtwirlIncludingTheBlocksYesAllOfItPleaseJustDeleteItAll(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getStage(dreamtwirlStageManager, regionX, regionZ);
        if (dreamtwirlStage.initateSelfDestruct()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.everything.success", (Object[])new Object[]{regionX, regionZ}), true);
            return 1;
        }
        throw FAILED_DREAMTWIRL_ALREADY_CLEARING.create();
    }

    private static int clearSDG(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        if (dreamtwirlStage.clearDesignGenerator()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.sdg.success", (Object[])new Object[]{MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf()), MirthdewCommand.getRegionXComponent(regionX), MirthdewCommand.getRegionZComponent(regionZ)}), true);
            return 1;
        }
        throw FAILED_SDG_ALREADY_CLEAR.create();
    }

    private static int clearRoomStorage(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        if (dreamtwirlStage.clearRoomStorage()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.rooms.success", (Object[])new Object[]{MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf()), MirthdewCommand.getRegionXComponent(regionX), MirthdewCommand.getRegionZComponent(regionZ)}), true);
            return 1;
        }
        throw FAILED_ROOM_STORAGE_ALREADY_CLEAR.create();
    }

    private static int clearAcherunes(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        if (dreamtwirlStage.clearAcherunes()) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.edit.clear.acherunes.success", (Object[])new Object[]{MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf()), MirthdewCommand.getRegionXComponent(regionX), MirthdewCommand.getRegionZComponent(regionZ)}), true);
            return 1;
        }
        throw FAILED_ACHERUNES_ALREADY_CLEAR.create();
    }

    private static int placeAllRooms(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        dreamtwirlStage.beginPlacingAllRooms();
        Component dreamtwirlComponent = MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf());
        Component regionXComponent = MirthdewCommand.getRegionXComponent(regionX);
        Component regionZComponent = MirthdewCommand.getRegionZComponent(regionZ);
        source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.edit.place_all_rooms", (Object[])new Object[]{dreamtwirlComponent, regionXComponent, regionZComponent}), true);
        return 1;
    }

    private static int info(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getStage(dreamtwirlStageManager, regionX, regionZ);
        Component dreamtwirlComponent = MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf());
        Component regionXComponent = MirthdewCommand.getRegionXComponent(regionX);
        Component regionZComponent = MirthdewCommand.getRegionZComponent(regionZ);
        MutableComponent ageComponent = dreamtwirlStage.getAgeTextComponent().copy().withStyle(ChatFormatting.YELLOW);
        List<PlaceableRoom> rooms = dreamtwirlStage.getRoomStorage().getRooms();
        int roomCount = rooms.size();
        MutableComponent roomCountComponent = Component.literal((String)String.valueOf(roomCount)).withStyle(ChatFormatting.AQUA);
        int placedRooms = (int)rooms.stream().filter(PlaceableRoom::isRoomPlaced).count();
        MutableComponent placedRoomsComponent = Component.literal((String)String.valueOf(placedRooms)).withStyle(ChatFormatting.GOLD);
        int placedPercentage = roomCount == 0 ? 100 : (int)Math.floor(100.0f * (float)placedRooms / (float)roomCount);
        int acheruneCount = dreamtwirlStage.getStageAcherunes().getAcheruneCount();
        MutableComponent acheruneCountComponent = Component.literal((String)String.valueOf(acheruneCount)).withStyle(ChatFormatting.LIGHT_PURPLE);
        MutableComponent SDGStatus = dreamtwirlStage.getStageDesignGenerator() == null ? Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.sdg.status.idle").withStyle(ChatFormatting.DARK_BLUE) : Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.sdg.status.generating").withStyle(ChatFormatting.GOLD);
        source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.summary", (Object[])new Object[]{dreamtwirlComponent, regionXComponent, regionZComponent}), true);
        source.sendSuccess(() -> MirthdewCommand.lambda$info$43((Component)ageComponent), true);
        if (dreamtwirlStage.isDeletingSelf()) {
            int chunkDeletionProgressPercentage = (int)Math.floor(100.0f * (float)dreamtwirlStage.getChunkDeletionProgress() / 900.0f);
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.deletion_progress", (Object[])new Object[]{Component.literal((String)String.valueOf(chunkDeletionProgressPercentage)).withStyle(ChatFormatting.GOLD)}).withStyle(ChatFormatting.RED), true);
        }
        source.sendSuccess(() -> MirthdewCommand.lambda$info$45((Component)roomCountComponent), true);
        source.sendSuccess(() -> MirthdewCommand.lambda$info$46((Component)placedRoomsComponent, placedPercentage), true);
        source.sendSuccess(() -> MirthdewCommand.lambda$info$47((Component)acheruneCountComponent), true);
        source.sendSuccess(() -> MirthdewCommand.lambda$info$48((Component)SDGStatus), true);
        return 1;
    }

    private static int acheruneInfo(CommandSourceStack source, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getStage(dreamtwirlStageManager, regionX, regionZ);
        Component dreamtwirlComponent = MirthdewCommand.getDreamtwirlComponent(dreamtwirlStage.isDeletingSelf());
        Component regionXComponent = MirthdewCommand.getRegionXComponent(regionX);
        Component regionZComponent = MirthdewCommand.getRegionZComponent(regionZ);
        int acheruneCount = dreamtwirlStage.getStageAcherunes().getAcheruneCount();
        MutableComponent acheruneCountComponent = Component.literal((String)String.valueOf(acheruneCount)).withStyle(ChatFormatting.LIGHT_PURPLE);
        source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.acherunes.summary", (Object[])new Object[]{dreamtwirlComponent, regionXComponent, regionZComponent}), true);
        source.sendSuccess(() -> MirthdewCommand.lambda$acheruneInfo$50((Component)acheruneCountComponent), true);
        for (Acherune acherune : dreamtwirlStage.getStageAcherunes().getAcherunes().stream().sorted(Comparator.comparingLong(ac -> ac.getId().timestamp())).toList()) {
            BlockPos acPos = acherune.getPos();
            BlockPosDimensional linkedPos = acherune.getLinkedPos();
            MutableComponent component = linkedPos == null ? Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.acherunes.single.unlinked", (Object[])new Object[]{acPos.getX(), acPos.getY(), acPos.getZ()}) : Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.acherunes.single.linked", (Object[])new Object[]{acPos.getX(), acPos.getY(), acPos.getZ(), linkedPos.getPos().getX(), linkedPos.getPos().getY(), linkedPos.getPos().getZ(), linkedPos.dimensionId().toString()});
            source.sendSuccess(() -> MirthdewCommand.lambda$acheruneInfo$52((Component)component), true);
        }
        return 1;
    }

    private static int queryValidRegions(CommandSourceStack source) throws CommandSyntaxException {
        DreamtwirlStageManager dsm = MirthdewCommand.getStageManager(source);
        int minX = dsm.getMinRegionX();
        int minZ = dsm.getMinRegionZ();
        int maxX = dsm.getMaxRegionX();
        int maxZ = dsm.getMaxRegionZ();
        MutableComponent component = Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.valid_regions.query", (Object[])new Object[]{minX, minZ, maxX, maxZ});
        source.sendSuccess(() -> MirthdewCommand.lambda$queryValidRegions$53((Component)component), true);
        return 1;
    }

    private static int setValidRegions(CommandSourceStack source, int minX, int minZ, int maxX, int maxZ) throws CommandSyntaxException {
        DreamtwirlStageManager dsm = MirthdewCommand.getStageManager(source);
        boolean success = dsm.setRegionBounds(minX, minZ, maxX, maxZ);
        if (success) {
            int minX2 = dsm.getMinRegionX();
            int minZ2 = dsm.getMinRegionZ();
            int maxX2 = dsm.getMaxRegionX();
            int maxZ2 = dsm.getMaxRegionZ();
            MutableComponent component = Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.valid_regions.set", (Object[])new Object[]{minX2, minZ2, maxX2, maxZ2});
            source.sendSuccess(() -> MirthdewCommand.lambda$setValidRegions$54((Component)component), true);
            return 1;
        }
        throw FAILED_INVALID_BOUNDS.create();
    }

    private static int setValidRegionsDefault(CommandSourceStack source) throws CommandSyntaxException {
        return MirthdewCommand.setValidRegions(source, -58593, -58593, 58592, 58592);
    }

    private static int joinPlayer(CommandSourceStack source, Entity entity, Collection<? extends Entity> targets) throws CommandSyntaxException {
        MirthdewEncoreEntityAttachment MEA = MirthdewEncoreEntityAttachment.fromEntity(entity);
        RegionPos regionPos = MEA.getDreamtwirlEntityData().getDreamtwirlRegion();
        if (regionPos == null) {
            throw FAILED_JOIN_TARGET_NOT_IN_DREAMTWIRL_EXCEPTION.create((Object)entity.getName());
        }
        return MirthdewCommand.join(source, regionPos.regionX, regionPos.regionZ, targets);
    }

    private static int join(CommandSourceStack source, int regionX, int regionZ, Collection<? extends Entity> targets) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = MirthdewCommand.getStageManager(source);
        DreamtwirlStage dreamtwirlStage = MirthdewCommand.getSafeStage(dreamtwirlStageManager, regionX, regionZ);
        int successCount = 0;
        for (Entity entity : targets) {
            if (!EntityDreamtwirlData.joinDreamtwirl(entity, dreamtwirlStage.getRegionPos())) continue;
            ++successCount;
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.join.success", (Object[])new Object[]{entity.getDisplayName(), regionX, regionZ}), true);
        }
        if (successCount == 0) {
            if (targets.size() == 1) {
                throw FAILED_JOIN_SINGLE_EXCEPTION.create((Object)targets.iterator().next().getName());
            }
            throw FAILED_JOIN_MULTIPLE_EXCEPTION.create((Object)targets.size());
        }
        return successCount;
    }

    private static int leave(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int successCount = 0;
        for (Entity entity : targets) {
            if (!EntityDreamtwirlData.leaveDreamtwirl(entity)) continue;
            ++successCount;
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.leave.success", (Object[])new Object[]{entity.getDisplayName()}), true);
        }
        if (successCount == 0) {
            if (targets.size() == 1) {
                throw FAILED_LEAVE_SINGLE_EXCEPTION.create((Object)targets.iterator().next().getName());
            }
            throw FAILED_LEAVE_MULTIPLE_EXCEPTION.create((Object)targets.size());
        }
        return successCount;
    }

    private static int addMirth(CommandSourceStack source, Collection<? extends Player> targets, long amount) {
        for (Player player : targets) {
            PlayerEntityMirthData pemd = MirthdewEncorePlayerEntityAttachment.fromPlayer(player).getMirthData();
            pemd.addMirth(amount, Long.MAX_VALUE);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.add.single", (Object[])new Object[]{amount, ((Player)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.add.many", (Object[])new Object[]{amount, targets.size()}), true);
        }
        return targets.size();
    }

    private static int removeMirth(CommandSourceStack source, Collection<? extends Player> targets, long amount) {
        for (Player player : targets) {
            PlayerEntityMirthData pemd = MirthdewCommand.getMirthData(player);
            pemd.removeMirth(amount);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.remove.single", (Object[])new Object[]{amount, ((Player)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.remove.many", (Object[])new Object[]{amount, targets.size()}), true);
        }
        return targets.size();
    }

    private static int setMirth(CommandSourceStack source, Collection<? extends Player> targets, long value) {
        for (Player player : targets) {
            PlayerEntityMirthData pemd = MirthdewCommand.getMirthData(player);
            pemd.setMirth(value);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.set.single", (Object[])new Object[]{value, ((Player)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.set.many", (Object[])new Object[]{value, targets.size()}), true);
        }
        return targets.size();
    }

    private static int queryMirth(CommandSourceStack source, Player target) {
        PlayerEntityMirthData pemd = MirthdewCommand.getMirthData(target);
        long mirth = pemd.getMirth();
        source.sendSuccess(() -> Component.translatable((String)"commands.mirthdew_encore.mirth.query", (Object[])new Object[]{target.getDisplayName(), mirth}), false);
        return Math.clamp(mirth, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static DreamtwirlStageManager getStageManager(CommandSourceStack source) throws CommandSyntaxException {
        DreamtwirlStageManager dreamtwirlStageManager = DreamtwirlStageManager.getMainDreamtwirlStageManager(source.getServer());
        if (dreamtwirlStageManager == null) {
            throw FAILED_NO_MANAGER_EXCEPTION.create();
        }
        return dreamtwirlStageManager;
    }

    private static DreamtwirlStage getSafeStage(DreamtwirlStageManager dreamtwirlStageManager, int regionX, int regionZ) throws CommandSyntaxException {
        DreamtwirlStage stage = MirthdewCommand.getStage(dreamtwirlStageManager, regionX, regionZ);
        if (stage.isDeletingSelf()) {
            throw FAILED_STAGE_DELETING.create();
        }
        return stage;
    }

    private static DreamtwirlStage getStage(DreamtwirlStageManager dreamtwirlStageManager, int regionX, int regionZ) throws CommandSyntaxException {
        RegionPos dreamtwirlRegionPos = new RegionPos(regionX, regionZ);
        DreamtwirlStage dreamtwirlStage = dreamtwirlStageManager.getDreamtwirlIfPresent(dreamtwirlRegionPos);
        if (dreamtwirlStage == null) {
            throw FAILED_DOES_NOT_EXIST_EXCEPTION.create();
        }
        return dreamtwirlStage;
    }

    private static PlayerEntityMirthData getMirthData(Player player) {
        return MirthdewEncorePlayerEntityAttachment.fromPlayer(player).getMirthData();
    }

    private static Component getDreamtwirlComponent(boolean isDeletingSelf) {
        MutableComponent component = Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.dreamtwirl");
        component = isDeletingSelf ? component.withStyle(ChatFormatting.RED).withStyle(ChatFormatting.STRIKETHROUGH) : component.withStyle(ChatFormatting.AQUA);
        return component;
    }

    private static Component getRegionXComponent(int regionX) {
        return Component.literal((String)String.valueOf(regionX)).withStyle(ChatFormatting.RED);
    }

    private static Component getRegionZComponent(int regionZ) {
        return Component.literal((String)String.valueOf(regionZ)).withStyle(ChatFormatting.BLUE);
    }

    private static /* synthetic */ Component lambda$setValidRegions$54(Component component) {
        return component;
    }

    private static /* synthetic */ Component lambda$queryValidRegions$53(Component component) {
        return component;
    }

    private static /* synthetic */ Component lambda$acheruneInfo$52(Component component) {
        return component;
    }

    private static /* synthetic */ Component lambda$acheruneInfo$50(Component acheruneCountComponent) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.acherunes.total", (Object[])new Object[]{acheruneCountComponent});
    }

    private static /* synthetic */ Component lambda$info$48(Component SDGStatus) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.sdg.status", (Object[])new Object[]{SDGStatus});
    }

    private static /* synthetic */ Component lambda$info$47(Component acheruneCountComponent) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.acherunes.total", (Object[])new Object[]{acheruneCountComponent});
    }

    private static /* synthetic */ Component lambda$info$46(Component placedRoomsComponent, int placedPercentage) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.rooms.placed", (Object[])new Object[]{placedRoomsComponent, placedPercentage});
    }

    private static /* synthetic */ Component lambda$info$45(Component roomCountComponent) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.rooms.total", (Object[])new Object[]{roomCountComponent});
    }

    private static /* synthetic */ Component lambda$info$43(Component ageComponent) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.info.time_since_creation", (Object[])new Object[]{ageComponent});
    }

    private static /* synthetic */ Component lambda$list$34(Component dreamtwirlComponent, Component regionXComponent, Component regionZComponent, Component ageComponent) {
        return Component.translatable((String)"commands.mirthdew_encore.dreamtwirl.list.entry", (Object[])new Object[]{dreamtwirlComponent, regionXComponent, regionZComponent, ageComponent});
    }
}

