/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.server.network;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import phanastrae.mirthdew_encore.block.entity.DoorMarkerBlockEntity;
import phanastrae.mirthdew_encore.block.entity.LychsealMarkerBlockEntity;
import phanastrae.mirthdew_encore.network.packet.SetDoorMarkerBlockPayload;
import phanastrae.mirthdew_encore.network.packet.SetLychsealMarkerBlockPayload;

public class MirthdewEncoreServerPacketHandler {
    public static void handleSetDoorMarkerBlock(SetDoorMarkerBlockPayload payload, Player player) {
        if (player.canUseGameMasterBlocks()) {
            BlockPos blockpos = payload.blockPos();
            Level level = player.level();
            BlockState blockstate = level.getBlockState(blockpos);
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity instanceof DoorMarkerBlockEntity) {
                DoorMarkerBlockEntity doorMarkerBlockEntity = (DoorMarkerBlockEntity)blockEntity;
                doorMarkerBlockEntity.setFinalState(payload.finalState());
                doorMarkerBlockEntity.setTargetLychsealName(payload.lychsealTarget());
                doorMarkerBlockEntity.setDoorType(payload.doorType());
                doorMarkerBlockEntity.setChanged();
                level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public static void handleSetLychsealMarkerBlock(SetLychsealMarkerBlockPayload payload, Player player) {
        if (player.canUseGameMasterBlocks()) {
            BlockPos blockpos = payload.blockPos();
            Level level = player.level();
            BlockState blockstate = level.getBlockState(blockpos);
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity instanceof LychsealMarkerBlockEntity) {
                LychsealMarkerBlockEntity lychsealMarkerBlockEntity = (LychsealMarkerBlockEntity)blockEntity;
                lychsealMarkerBlockEntity.setLychsealName(payload.lychsealTarget());
                lychsealMarkerBlockEntity.setChanged();
                level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            }
        }
    }
}

