/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.structure.intermediate;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.structure.intermediate.IntermediateStructureStorage;

public class IntermediateGenLevel
implements WorldGenLevel {
    private static final LevelTickAccess<Block> BLOCK_TICK_DUMMY = IntermediateGenLevel.createDummyTickAccess();
    private static final LevelTickAccess<Fluid> FLUID_TICK_DUMMY = IntermediateGenLevel.createDummyTickAccess();
    private final WorldGenLevel level;
    private final IntermediateStructureStorage intermediateStorage;
    private final RandomSource random;

    public IntermediateGenLevel(IntermediateStructureStorage intermediateStructureStorage, WorldGenLevel level) {
        this.intermediateStorage = intermediateStructureStorage;
        this.level = level;
        this.random = RandomSource.create((long)level.getRandom().nextLong());
    }

    public boolean skipUpdatesInStructurePiece() {
        return true;
    }

    public static <T> LevelTickAccess<T> createDummyTickAccess() {
        return new LevelTickAccess<T>(){

            public boolean willTickThisTick(BlockPos pos, T type) {
                return false;
            }

            public void schedule(ScheduledTick<T> tick) {
            }

            public boolean hasScheduledTick(BlockPos pos, T type) {
                return false;
            }

            public int count() {
                return 0;
            }
        };
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockState state = this.intermediateStorage.getBlockState(pos);
        if (state.is(Blocks.STRUCTURE_VOID)) {
            return this.level.getBlockState(pos);
        }
        return state;
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockEntity blockEntity = this.intermediateStorage.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity;
        }
        BlockState state = this.getBlockState(pos);
        if (state.is(Blocks.STRUCTURE_VOID)) {
            return this.level.getBlockEntity(pos);
        }
        return null;
    }

    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> predicate) {
        return predicate.test(this.getBlockState(pos));
    }

    public boolean isFluidAtPosition(BlockPos pos, Predicate<FluidState> predicate) {
        return predicate.test(this.getFluidState(pos));
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        return this.intermediateStorage.setBlockState(pos, state);
    }

    public boolean removeBlock(BlockPos pos, boolean isMoving) {
        return this.intermediateStorage.setBlockState(pos, Blocks.AIR.defaultBlockState());
    }

    public boolean destroyBlock(BlockPos pos, boolean dropBlock, @Nullable Entity entity, int recursionLeft) {
        return this.intermediateStorage.setBlockState(pos, Blocks.AIR.defaultBlockState());
    }

    public boolean addFreshEntity(Entity entity) {
        this.intermediateStorage.addEntity(entity);
        return true;
    }

    public void scheduleTick(BlockPos pos, Fluid fluid, int delay) {
    }

    public void scheduleTick(BlockPos pos, Fluid fluid, int delay, TickPriority priority) {
    }

    public void scheduleTick(BlockPos pos, Block block, int delay) {
    }

    public void scheduleTick(BlockPos pos, Block block, int delay, TickPriority priority) {
    }

    public void playSound(@Nullable Player player, BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
    }

    public void addParticle(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void levelEvent(@Nullable Player player, int type, BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 pos, GameEvent.Context context) {
    }

    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus chunkStatus, boolean requireChunk) {
        if (requireChunk) {
            return this.level.getChunk(x, z, chunkStatus, true);
        }
        return null;
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BLOCK_TICK_DUMMY;
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return FLUID_TICK_DUMMY;
    }

    public RandomSource getRandom() {
        return this.random;
    }

    public List<Entity> getEntities(@Nullable Entity entity, AABB area, Predicate<? super Entity> predicate) {
        return List.of();
    }

    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate) {
        return List.of();
    }

    public ServerLevel getLevel() {
        return this.level.getLevel();
    }

    @Nullable
    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    public List<? extends Player> players() {
        return this.level.players();
    }

    public long nextSubTickCount() {
        return this.level.nextSubTickCount();
    }

    public ChunkSource getChunkSource() {
        return this.level.getChunkSource();
    }

    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        return this.level.getHeight(heightmapType, x, z);
    }

    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    public LevelData getLevelData() {
        return this.level.getLevelData();
    }

    public BiomeManager getBiomeManager() {
        return this.level.getBiomeManager();
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.level.getUncachedNoiseBiome(x, y, z);
    }

    public DifficultyInstance getCurrentDifficultyAt(BlockPos pos) {
        return this.level.getCurrentDifficultyAt(pos);
    }

    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    public DimensionType dimensionType() {
        return this.level.dimensionType();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    public float getShade(Direction direction, boolean shade) {
        return this.level.getShade(direction, shade);
    }

    public int getSkyDarken() {
        return this.level.getSkyDarken();
    }

    public int getSeaLevel() {
        return this.level.getSeaLevel();
    }

    public long getSeed() {
        return this.level.getSeed();
    }

    public boolean isClientSide() {
        return this.level.isClientSide();
    }
}

