/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.util.graph;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import phanastrae.mirthdew_encore.MirthdewEncore;
import phanastrae.mirthdew_encore.util.graph.DirectedEdge;
import phanastrae.mirthdew_encore.util.graph.Node;

public class DirectedGraph {
    public static final Codec<DirectedGraph> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.listOf().fieldOf("nodes").forGetter(graph -> graph.getNodes().values().stream().filter(node -> !node.isEmpty()).map(Node::getId).toList()), (App)DirectedEdge.CODEC.listOf().fieldOf("edges").forGetter(graph -> graph.getEdges().values().stream().toList())).apply((Applicative)instance, DirectedGraph::new));
    private Map<Long, Node> nodes = new Object2ObjectOpenHashMap();
    private Map<Long, DirectedEdge> edges = new Object2ObjectOpenHashMap();

    public DirectedGraph() {
    }

    public DirectedGraph(List<Long> nodes, List<DirectedEdge> edges) {
        for (Long l : nodes) {
            this.nodes.put(l, new Node(l));
        }
        for (DirectedEdge edge : edges) {
            long eid = edge.getId();
            Node start = this.getOrCreateNode(edge.getStartId());
            Node end = this.getOrCreateNode(edge.getEndId());
            start.addOutgoingEdge(eid);
            end.addIncomingEdge(eid);
            this.edges.put(eid, edge);
        }
    }

    public Node getOrCreateNode(long id) {
        if (this.nodes.containsKey(id)) {
            return this.nodes.get(id);
        }
        Node node = new Node(id);
        this.nodes.put(id, node);
        return node;
    }

    @Nullable
    public Node getNode(long id) {
        return this.nodes.getOrDefault(id, null);
    }

    @Nullable
    public DirectedEdge getEdge(long id) {
        return this.edges.getOrDefault(id, null);
    }

    public void addEdge(long start, long end, RandomSource random) {
        long edgeId = this.getNextEdgeId(random);
        DirectedEdge edge = new DirectedEdge(edgeId, start, end);
        this.edges.put(edgeId, edge);
        Node s = this.getOrCreateNode(start);
        s.addOutgoingEdge(edgeId);
        Node e = this.getOrCreateNode(end);
        e.addIncomingEdge(edgeId);
    }

    public long getNextNodeId(RandomSource random) {
        for (int i = 0; i < 100; ++i) {
            long id = random.nextLong();
            if (this.edges.containsKey(id)) continue;
            return id;
        }
        MirthdewEncore.LOGGER.error("Somehow failed to generate a new node id 100 times in a row?????? Assigning a random id");
        return random.nextLong();
    }

    public long getNextEdgeId(RandomSource random) {
        for (int i = 0; i < 100; ++i) {
            long id = random.nextLong();
            if (this.edges.containsKey(id)) continue;
            return id;
        }
        MirthdewEncore.LOGGER.error("Somehow failed to generate a new edge id 100 times in a row?????? Assigning a random id");
        return random.nextLong();
    }

    public void removeNode(long id) {
        Node node = this.getNode(id);
        if (node != null) {
            List<Long> in;
            List<Long> out = node.getOutgoingEdges();
            if (out != null) {
                for (long edgeId : out) {
                    this.removeEdge(edgeId, id);
                }
            }
            if ((in = node.getIncomingEdges()) != null) {
                for (long edgeId : in) {
                    this.removeEdge(edgeId, id);
                }
            }
        }
        this.nodes.remove(id);
    }

    public void removeEdge(long id, long exceptNode) {
        DirectedEdge edge = this.getEdge(id);
        if (edge != null) {
            Node end;
            Node start;
            if (edge.getStartId() != exceptNode && (start = this.getNode(edge.getStartId())) != null) {
                start.removeOutgoingEdge(id);
                if (start.isEmpty()) {
                    this.nodes.remove(start.getId());
                }
            }
            if (edge.getEndId() != exceptNode && (end = this.getNode(edge.getEndId())) != null) {
                end.removeIncomingEdge(id);
                if (end.isEmpty()) {
                    this.nodes.remove(end.getId());
                }
            }
            this.edges.remove(id);
        }
    }

    public Map<Long, Node> getNodes() {
        return this.nodes;
    }

    public Map<Long, DirectedEdge> getEdges() {
        return this.edges;
    }
}

