/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.util.graph;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Node {
    private final long id;
    @Nullable
    private List<Long> outgoingEdges;
    @Nullable
    private List<Long> incomingEdges;

    public Node(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void addOutgoingEdge(long id) {
        if (this.outgoingEdges == null) {
            this.outgoingEdges = new ObjectArrayList();
        }
        if (!this.outgoingEdges.contains(id)) {
            this.outgoingEdges.add(id);
        }
    }

    public void addIncomingEdge(long id) {
        if (this.incomingEdges == null) {
            this.incomingEdges = new ObjectArrayList();
        }
        if (!this.incomingEdges.contains(id)) {
            this.incomingEdges.add(id);
        }
    }

    public void removeOutgoingEdge(long id) {
        if (this.outgoingEdges != null) {
            this.outgoingEdges.remove(id);
        }
    }

    public void removeIncomingEdge(long id) {
        if (this.incomingEdges != null) {
            this.incomingEdges.remove(id);
        }
    }

    @Nullable
    public List<Long> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Nullable
    public List<Long> getIncomingEdges() {
        return this.incomingEdges;
    }

    public boolean isEmpty() {
        return !(this.incomingEdges != null && !this.incomingEdges.isEmpty() || this.outgoingEdges != null && !this.outgoingEdges.isEmpty());
    }
}

