/*
 * Decompiled with CFR 0.152.
 */
package phanastrae.mirthdew_encore.world.gen.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import phanastrae.mirthdew_encore.block.MirthdewEncoreBlocks;
import phanastrae.mirthdew_encore.world.biome.MirthdewEncoreBiomes;

public class DreamtwirlChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<DreamtwirlChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryOps.retrieveElement(MirthdewEncoreBiomes.DREAMTWIRL)).apply((Applicative)instance, instance.stable(DreamtwirlChunkGenerator::new)));
    protected static final BlockState DREAMTWIRL_BARRIER = MirthdewEncoreBlocks.DREAMTWIRL_BARRIER.defaultBlockState();

    public DreamtwirlChunkGenerator(Holder.Reference<Biome> biomeEntry) {
        super((BiomeSource)new FixedBiomeSource(biomeEntry));
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void buildSurface(WorldGenRegion region, StructureManager structures, RandomState noiseConfig, ChunkAccess chunk) {
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunk, StructureManager structureAccessor) {
        if (this.isBorderChunk(chunk)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            ChunkPos chunkPos = chunk.getPos();
            int cx = chunkPos.x;
            int cz = chunkPos.z;
            int bottomY = world.getMinBuildHeight();
            int topY = world.getMaxBuildHeight();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int y = bottomY; y < topY; ++y) {
                        int x = SectionPos.sectionToBlockCoord((int)cx, (int)i);
                        int z = SectionPos.sectionToBlockCoord((int)cz, (int)j);
                        world.setBlock((BlockPos)mutable.set(x, y, z), DREAMTWIRL_BARRIER, 2);
                    }
                }
            }
        }
    }

    public boolean isBorderChunk(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.getPos();
        int cx = chunkPos.x & 0x1F;
        int cz = chunkPos.z & 0x1F;
        if (cx == 0 || cx == 31) {
            return true;
        }
        return cz == 0 || cz == 31;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types heightmap, LevelHeightAccessor world, RandomState noiseConfig) {
        return 128;
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor world, RandomState noiseConfig) {
        return new NoiseColumn(0, new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> text, RandomState noiseConfig, BlockPos pos) {
    }

    public void applyCarvers(WorldGenRegion chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, ChunkAccess chunk, GenerationStep.Carving carverStep) {
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public int getMinY() {
        return 0;
    }

    public int getGenDepth() {
        return 256;
    }

    public int getSeaLevel() {
        return 0;
    }
}

