/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growable_ores_extension.block.entity;

import com.skniro.growable_ores_extension.block.Alchemyblock;
import com.skniro.growable_ores_extension.block.entity.AlchemyBlockEntityType;
import com.skniro.growable_ores_extension.block.entity.ImplementedInventory;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipe;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipeInput;
import com.skniro.growable_ores_extension.recipe.AlchemyRecipeType;
import com.skniro.growable_ores_extension.screen.AlchemyBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Alchemyblockentity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
ItemOwner {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private float rotation = 0.0f;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> Alchemyblockentity.this.progress;
                case 1 -> Alchemyblockentity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    Alchemyblockentity.this.progress = value;
                }
                case 1: {
                    Alchemyblockentity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public Alchemyblockentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AlchemyBlockEntityType.ALCHEMY_BLOCK_ENTITY.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        return this.getItem(0);
    }

    @Override
    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.growableores.cane_converter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new AlchemyBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, this.inventory);
        valueOutput.putInt("cane_converter.progress", this.progress);
        valueOutput.putInt("cane_converter.max_progress", this.maxProgress);
    }

    protected void loadAdditional(ValueInput valueInput) {
        ContainerHelper.loadAllItems((ValueInput)valueInput, this.inventory);
        this.progress = valueInput.getInt("cane_converter.progress").orElse(0);
        this.maxProgress = valueInput.getInt("cane_converter.max_progress").orElse(72);
        super.loadAdditional(valueInput);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            Alchemyblockentity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<AlchemyCraftingRecipe>> recipe = this.getCurrentRecipe();
        this.removeItem(0, 1);
        this.setItem(1, new ItemStack((ItemLike)((AlchemyCraftingRecipe)recipe.get().value()).output().getItem(), this.getItem(1).getCount() + ((AlchemyCraftingRecipe)recipe.get().value()).output().getCount()));
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        if (direction != Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 1;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.getItem(1).isEmpty() || this.getItem(1).getCount() < this.getItem(1).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<AlchemyCraftingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((AlchemyCraftingRecipe)recipe.get().value()).output();
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<AlchemyCraftingRecipe>> getCurrentRecipe() {
        return this.getLevel().getServer().getRecipeManager().getRecipeFor((RecipeType)AlchemyRecipeType.Cane_Converter_TYPE.get(), (RecipeInput)new AlchemyCraftingRecipeInput((ItemStack)this.inventory.get(0)), this.getLevel());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.getItem(1).isEmpty() || this.getItem(1).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.getItem(1).isEmpty() ? 64 : this.getItem(1).getMaxStackSize();
        int currentCount = this.getItem(1).getCount();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    protected void applyImplicitComponents(DataComponentGetter p_426426_) {
        super.applyImplicitComponents(p_426426_);
        ((ItemContainerContents)p_426426_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.inventory);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_426984_) {
        super.collectImplicitComponents(p_426984_);
        p_426984_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.inventory));
    }

    public void removeComponentsFromTag(ValueOutput p_424412_) {
        p_424412_.discard("Items");
    }

    public Level level() {
        return this.level;
    }

    public Vec3 position() {
        return this.getBlockPos().getCenter();
    }

    public float getVisualRotationYInDegrees() {
        return ((Direction)this.getBlockState().getValue(Alchemyblock.FACING)).getOpposite().toYRot();
    }
}

