/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growable_ores_extension.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipeInput;
import com.skniro.growable_ores_extension.recipe.AlchemyRecipeType;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AlchemyCraftingRecipe
implements Recipe<AlchemyCraftingRecipeInput> {
    final ItemStack output;
    final Ingredient ingredient;
    @Nullable
    private PlacementInfo ingredientPlacement;

    public AlchemyCraftingRecipe(Ingredient ingredients, ItemStack output) {
        this.output = output;
        this.ingredient = ingredients;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public ItemStack output() {
        return this.output;
    }

    public boolean matches(AlchemyCraftingRecipeInput input, Level world) {
        if (world.isClientSide()) {
            return false;
        }
        return this.ingredient.test(input.getItem(0));
    }

    public ItemStack assemble(AlchemyCraftingRecipeInput input, HolderLookup.Provider lookup) {
        return this.output.copy();
    }

    public RecipeSerializer<? extends Recipe<AlchemyCraftingRecipeInput>> getSerializer() {
        return (RecipeSerializer)AlchemyRecipeType.Cane_Converter_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<AlchemyCraftingRecipeInput>> getType() {
        return (RecipeType)AlchemyRecipeType.Cane_Converter_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.ingredientPlacement;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<AlchemyCraftingRecipe> {
        public static final MapCodec<AlchemyCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)inst, AlchemyCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlchemyCraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AlchemyCraftingRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, AlchemyCraftingRecipe::output, AlchemyCraftingRecipe::new);

        public MapCodec<AlchemyCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlchemyCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

