/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growable_ores_extension.block.entity;

import com.skniro.growable_ores_extension.block.entity.AlchemyBlockEntityType;
import com.skniro.growable_ores_extension.block.entity.ImplementedInventory;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipe;
import com.skniro.growable_ores_extension.recipe.AlchemyRecipeType;
import com.skniro.growable_ores_extension.screen.AlchemyBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class Alchemyblockentity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private LazyOptional<? extends IItemHandler>[] lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> Alchemyblockentity.this.progress;
                case 1 -> Alchemyblockentity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    Alchemyblockentity.this.progress = value;
                }
                case 1: {
                    Alchemyblockentity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public Alchemyblockentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AlchemyBlockEntityType.ALCHEMY_BLOCK_ENTITY.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        return this.m_8020_(0);
    }

    @Override
    public void m_6596_() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.growableores.cane_converter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new AlchemyBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("cane_converter.progress", this.progress);
        nbt.m_128405_("cane_converter.max_progress", this.maxProgress);
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.progress = nbt.m_128451_("cane_converter.progress");
        this.maxProgress = nbt.m_128451_("cane_converter.max_progress");
        super.m_142466_(nbt);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            Alchemyblockentity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<AlchemyCraftingRecipe> recipe = this.getCurrentRecipe();
        this.m_7407_(0, 1);
        this.m_6836_(1, new ItemStack((ItemLike)recipe.get().m_8043_().m_41720_(), this.m_8020_(1).m_41613_() + recipe.get().m_8043_().m_41613_()));
    }

    @Override
    public int[] m_7071_(Direction direction) {
        if (direction != Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return slot != 1;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.m_8020_(1).m_41619_() || this.m_8020_(1).m_41613_() < this.m_8020_(1).m_41741_();
    }

    private boolean hasRecipe() {
        Optional<AlchemyCraftingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = recipe.get().m_8043_();
        return this.canInsertAmountIntoOutputSlot(output.m_41613_()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<AlchemyCraftingRecipe> getCurrentRecipe() {
        SimpleContainer inv = new SimpleContainer(this.m_6643_());
        for (int i = 0; i < this.m_6643_(); ++i) {
            inv.m_6836_(i, this.m_8020_(i));
        }
        return this.m_58904_().m_7465_().m_44015_((RecipeType)AlchemyRecipeType.Cane_Converter_TYPE.get(), (Container)inv, this.m_58904_());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.m_8020_(1).m_41619_() || this.m_8020_(1).m_41720_() == output.m_41720_();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.m_8020_(1).m_41619_() ? 64 : this.m_8020_(1).m_41741_();
        int currentCount = this.m_8020_(1).m_41613_();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.f_58859_) {
            return switch (facing) {
                case Direction.DOWN -> this.lazyItemHandler[1].cast();
                default -> this.lazyItemHandler[0].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.lazyItemHandler.length; ++x) {
            this.lazyItemHandler[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }
}

