/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growable_ores_extension.block.entity;

import com.skniro.growable_ores_extension.block.entity.AlchemyBlockEntityType;
import com.skniro.growable_ores_extension.block.entity.ImplementedInventory;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipe;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipeInput;
import com.skniro.growable_ores_extension.recipe.AlchemyRecipeType;
import com.skniro.growable_ores_extension.screen.AlchemyBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.Nullable;

public class Alchemyblockentity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private LazyOptional<? extends IItemHandler>[] lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> Alchemyblockentity.this.progress;
                case 1 -> Alchemyblockentity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    Alchemyblockentity.this.progress = value;
                }
                case 1: {
                    Alchemyblockentity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public Alchemyblockentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AlchemyBlockEntityType.ALCHEMY_BLOCK_ENTITY.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        return this.getItem(0);
    }

    @Override
    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.growableores.cane_converter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new AlchemyBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        nbt.putInt("cane_converter.progress", this.progress);
        nbt.putInt("cane_converter.max_progress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        this.progress = nbt.getInt("cane_converter.progress");
        this.maxProgress = nbt.getInt("cane_converter.max_progress");
        super.loadAdditional(nbt, registryLookup);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            Alchemyblockentity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<AlchemyCraftingRecipe>> recipe = this.getCurrentRecipe();
        this.removeItem(0, 1);
        this.setItem(1, new ItemStack((ItemLike)((AlchemyCraftingRecipe)recipe.get().value()).output().getItem(), this.getItem(1).getCount() + ((AlchemyCraftingRecipe)recipe.get().value()).output().getCount()));
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        if (direction != Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 1;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.getItem(1).isEmpty() || this.getItem(1).getCount() < this.getItem(1).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<AlchemyCraftingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((AlchemyCraftingRecipe)recipe.get().value()).getResultItem(null);
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<AlchemyCraftingRecipe>> getCurrentRecipe() {
        return this.getLevel().getRecipeManager().getRecipeFor((RecipeType)AlchemyRecipeType.Cane_Converter_TYPE.get(), (RecipeInput)new AlchemyCraftingRecipeInput((ItemStack)this.inventory.get(0)), this.getLevel());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.getItem(1).isEmpty() || this.getItem(1).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.getItem(1).isEmpty() ? 64 : this.getItem(1).getMaxStackSize();
        int currentCount = this.getItem(1).getCount();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.remove) {
            return switch (facing) {
                case Direction.DOWN -> this.lazyItemHandler[1].cast();
                default -> this.lazyItemHandler[0].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.lazyItemHandler.length; ++x) {
            this.lazyItemHandler[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    }
}

