/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.growable_ores_extension.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.growable_ores_extension.recipe.AlchemyCraftingRecipeInput;
import com.skniro.growable_ores_extension.recipe.AlchemyRecipeType;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record AlchemyCraftingRecipe(Ingredient inputItem, ItemStack output) implements Recipe<AlchemyCraftingRecipeInput>
{
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.inputItem);
        return list;
    }

    public boolean matches(AlchemyCraftingRecipeInput input, Level world) {
        if (world.isClientSide()) {
            return false;
        }
        return this.inputItem.test(input.getItem(0));
    }

    public ItemStack assemble(AlchemyCraftingRecipeInput input, HolderLookup.Provider lookup) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AlchemyRecipeType.Cane_Converter_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AlchemyRecipeType.Cane_Converter_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AlchemyCraftingRecipe> {
        public static final MapCodec<AlchemyCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(AlchemyCraftingRecipe::inputItem), (App)ItemStack.CODEC.fieldOf("result").forGetter(AlchemyCraftingRecipe::output)).apply((Applicative)inst, AlchemyCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlchemyCraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AlchemyCraftingRecipe::inputItem, (StreamCodec)ItemStack.STREAM_CODEC, AlchemyCraftingRecipe::output, AlchemyCraftingRecipe::new);

        public MapCodec<AlchemyCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlchemyCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

