package io.github.xrickastley.originsgenshin.action.entity;

import com.google.gson.JsonSyntaxException;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsgenshin.OriginsGenshin;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;

public class ElementalDamageAction {
	private static void action(SerializableData.Instance data, class_1297 entity) {
		Float damageAmount = data.get("amount");
		final List<Modifier> modifiers = new LinkedList<>();

		data.<Modifier>ifPresent("modifier", modifiers::add);
		data.<List<Modifier>>ifPresent("modifiers", modifiers::addAll);

		if (!modifiers.isEmpty() && entity instanceof final class_1309 livingEntity) {
			final float maxHealth = livingEntity.method_6063();
			final float newDamageAmount = (float) ModifierUtil.applyModifiers(livingEntity, modifiers, maxHealth);

			damageAmount = newDamageAmount > maxHealth ? newDamageAmount - maxHealth : newDamageAmount;
		}

		if (damageAmount == null) return;

		try {
			class_1282 source = MiscUtil.createDamageSource(entity.method_48923(), data.get("source"), data.get("damage_type"));

			if (data.isPresent("element") && entity instanceof final class_1309 livingEntity)
				source = new ElementalDamageSource(
					source,
					data.<ElementalApplication.Builder>get("element").build(livingEntity),
					data.<InternalCooldownContext.Builder>get("internal_cooldown").build(livingEntity)
				);

			entity.method_5643(source, damageAmount);
		} catch (JsonSyntaxException e) {
			OriginsGenshin
				.sublogger()
				.error("Error trying to create damage source in a `damage` bi-entity action: " + e.getMessage(), e);
		}
	}

	public static ActionFactory<class_1297> getFactory() {
		return new ActionFactory<>(SevenElements.identifier("elemental_damage"),
			new SerializableData()
				.add("amount", SerializableDataTypes.FLOAT, null)
				.add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null)
				.add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null)
				.add("modifier", Modifier.DATA_TYPE, null)
				.add("modifiers", Modifier.LIST_TYPE, null)
				.add("element", SevenElementsDataTypes.ELEMENTAL_APPLICATION_BUILDER)
				.add("internal_cooldown", SevenElementsDataTypes.INTERNAL_COOLDOWN_CONTEXT_BUILDER, InternalCooldownContext.Builder.ofNone()),
			ElementalDamageAction::action
		);
	}
}
