package io.github.xrickastley.originsgenshin.data;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3545;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;

public class ChargeRender {
	public static final ChargeRender DEFAULT = new ChargeRender(Method.SPLIT, null);

	protected ElementalSkillIcon skillIcon;
	protected final Method method;
	protected final List<class_3545<Integer, ConditionFactory<class_1297>.Instance>> conditions;

	public ChargeRender(Method method, List<class_3545<Integer, ConditionFactory<class_1297>.Instance>> conditions) {
		this.method = method;
		this.conditions = conditions;
	}

	protected ChargeRender setElementalSkillIcon(ElementalSkillIcon skillIcon) {
		this.skillIcon = skillIcon;

		return this;
	}

	public Method getMethod() {
		return method;
	}

	public List<class_3545<Integer, ConditionFactory<class_1297>.Instance>> getConditions() {
		return conditions;
	}

	public int getCurrentCharges(class_1657 player) {
		if (this.method == Method.SPLIT) {
			class_3545<Integer, Integer> pair = this.skillIcon.resolveCooldownResource(player);

			int cur = pair.method_15442();
			int max = pair.method_15441();

			return cur / (max / this.skillIcon.getCharges());
		}

		if (conditions == null) return 1;

		for (class_3545<Integer, ConditionFactory<class_1297>.Instance> chargeCondition : conditions) {
			if (chargeCondition.method_15441().test(player)) return chargeCondition.method_15442();
		}

		return 0;
	}

	public static enum Method {
		SPLIT, CONDITIONAL;
	}
}
