package io.github.xrickastley.originsgenshin.data;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;

public abstract class RenderableSkill {
	protected ActiveCooldownPower power;
	protected final boolean showCooldown;
	protected final boolean shouldRender;
	protected final List<RenderableIcon> icons;
	protected final ConditionFactory<class_1297>.Instance disable;

	public RenderableSkill(boolean showCooldown, boolean shouldRender, ConditionFactory<class_1297>.Instance disableCondition, List<RenderableIcon> iconConditions) {
		this.showCooldown = showCooldown;
		this.shouldRender = shouldRender;
		this.icons = iconConditions;
		this.disable = disableCondition;

		if (this.icons != null) this.icons.forEach(icon -> icon.setSkill(this));
	}

	public RenderableSkill setPower(ActiveCooldownPower power) {
		this.power = power;

		return this;
	}

	public ActiveCooldownPower getPower() {
		return power;
	}

	public boolean shouldShowCooldown() {
		return this.showCooldown;
	}

	public boolean shouldRender() {
		return this.shouldRender;
	}

	public ConditionFactory<class_1297>.Instance getDisableCondition() {
		return disable;
	}

	public List<RenderableIcon> getIcons() {
		return icons;
	}

	public RenderableIcon getRenderedIcon(class_1657 entity) {
		if (!shouldRender() || icons == null) return null;

		for (RenderableIcon icon : icons) {
			if (icon.shouldRender(entity)) return icon;
		}

		return null;
	}

	public boolean isDisabled(class_1657 entity) {
		return disable == null
			? false
			: disable.test(entity);
	}
}
