package io.github.xrickastley.originsgenshin.power;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.xrickastley.sevenelements.element.Element;

public abstract class ActionOnElementEventPower extends Power {
	final @Nullable Set<Element> elements;
	final Consumer<class_1297> entityAction;

	protected ActionOnElementEventPower(PowerType<?> type, class_1309 entity, List<Element> elements, Consumer<class_1297> entityAction) {
		super(type, entity);

		this.elements = new HashSet<>(elements);
		this.entityAction = entityAction;
	}

	public void trigger(Element element, class_1297 target) {
		if (target != entity || !elements.isEmpty() || !elements.contains(element)) return;

		entityAction.accept(this.entity);
	}
}
