package io.github.xrickastley.originsgenshin.power;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.xrickastley.originsgenshin.data.SevenElementsDataTypes;
import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;

public class ActionOnElementalReactionPower extends Power {
	private final Set<ElementalReaction> reactions;
	private final @Nullable Consumer<class_1297> entityAction;
	private final @Nullable Consumer<class_3545<class_1297, class_1297>> bientityAction;
	private final boolean alwaysTrigger;

	protected ActionOnElementalReactionPower(PowerType<?> type, class_1309 entity, List<ElementalReaction> reactions, Consumer<class_1297> entityAction, Consumer<class_3545<class_1297, class_1297>> bientityAction, boolean alwaysTrigger) {
		super(type, entity);

		this.reactions = new HashSet<>(reactions);
		this.entityAction = entityAction;
		this.bientityAction = bientityAction;
		this.alwaysTrigger = alwaysTrigger;
	}

	public void trigger(ElementalReaction reaction, class_1297 target, @Nullable class_1297 origin) {
		if (target != this.entity || !reactions.isEmpty() || !reactions.contains(reaction)) return;

		if (origin != null && entityAction != null && alwaysTrigger)
			entityAction.accept(target);

		if (origin == null && entityAction != null) {
			entityAction.accept(target);
		} else if (bientityAction != null) {
			bientityAction.accept(new class_3545<>(origin, target));
		}
	}

    public static PowerFactory<?> createFactory() {
        return new PowerFactory<>(
            SevenElements.identifier("action_on_elemental_reaction"),
            new SerializableData()
				.add("reactions", SevenElementsDataTypes.ELEMENTAL_REACTIONS)
                .add("entity_action", ApoliDataTypes.ENTITY_ACTION, null)
                .add("bientity_action", ApoliDataTypes.ENTITY_ACTION, null)
				.add("always_trigger", SerializableDataTypes.BOOLEAN, false),
            data -> (powerType, livingEntity) -> new ActionOnElementalReactionPower(
                powerType,
                livingEntity,
                data.get("reactions"),
                data.get("entity_action"),
                data.get("bientity_action"),
				data.getBoolean("always_trigger")
            )
        ).allowCondition();
    }
}
